/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.utils;

import java.io.IOException;
import java.io.InputStream;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class ReusableBufferInputStream
extends InputStream {
    private final ReusableBuffer data;

    public ReusableBufferInputStream(ReusableBuffer data) {
        assert (data != null);
        this.data = data;
    }

    @Override
    public int read() throws IOException {
        if (this.data.hasRemaining()) {
            return this.data.get();
        }
        return -1;
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        int bytesRemaining = this.data.remaining();
        if (bytesRemaining == 0) {
            return -1;
        }
        int bytesToRead = bytesRemaining >= length ? length : bytesRemaining;
        this.data.get(buf, offset, bytesToRead);
        return bytesToRead;
    }
}

