/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.pbrpc.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class ReusableBufferOutputStream
extends OutputStream {
    public static final int BUFF_SIZE = 8192;
    private final int bufSize;
    private final ReusableBuffer firstBuffer;
    private List<ReusableBuffer> buffers;
    private ReusableBuffer currentBuffer;
    private int length;

    public ReusableBufferOutputStream(int bufSize) {
        this.bufSize = bufSize;
        this.currentBuffer = this.firstBuffer = BufferPool.allocate(bufSize);
        this.length = 0;
    }

    private ReusableBuffer checkAndGetBuffer(int requiredSpace) {
        if (this.currentBuffer.remaining() < requiredSpace) {
            if (this.buffers == null) {
                this.buffers = new ArrayList<ReusableBuffer>(15);
            }
            int newBufSize = this.bufSize >= requiredSpace ? this.bufSize : requiredSpace;
            ReusableBuffer buf = BufferPool.allocate(newBufSize);
            this.buffers.add(buf);
            this.currentBuffer = buf;
        }
        return this.currentBuffer;
    }

    public void appendBuffer(ReusableBuffer buffer) {
        this.currentBuffer = buffer;
        if (this.buffers == null) {
            this.buffers = new ArrayList<ReusableBuffer>(15);
        }
        buffer.position(buffer.limit());
        this.buffers.add(buffer);
        this.length += buffer.remaining();
    }

    public void flip() {
        this.firstBuffer.flip();
        if (this.buffers != null) {
            for (ReusableBuffer buffer : this.buffers) {
                buffer.flip();
            }
        }
        this.currentBuffer = this.firstBuffer;
    }

    public void freeBuffers() {
        BufferPool.free(this.firstBuffer);
        if (this.buffers != null) {
            for (ReusableBuffer buffer : this.buffers) {
                BufferPool.free(buffer);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkAndGetBuffer(1).put((byte)b);
        ++this.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkAndGetBuffer(len).put(b, off, len);
        this.length += len;
    }

    public ReusableBuffer[] getBuffers() {
        if (this.buffers == null) {
            return new ReusableBuffer[]{this.firstBuffer};
        }
        ReusableBuffer[] arr = new ReusableBuffer[this.buffers.size() + 1];
        arr[0] = this.firstBuffer;
        for (int i = 1; i <= this.buffers.size(); ++i) {
            arr[i] = this.buffers.get(i - 1);
        }
        return arr;
    }

    public int length() {
        return this.length;
    }
}

