/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.trace;

import java.io.FileOutputStream;
import java.io.IOException;
import org.xtreemfs.foundation.logging.Logging;

public class Tracer {
    public static final boolean COLLECT_TRACES = false;
    private static Tracer theInstance;
    private final FileOutputStream fos;

    private Tracer(String traceFileName) throws IOException {
        theInstance = this;
        this.fos = new FileOutputStream(traceFileName, true);
        if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.misc, this, "TRACING IS ENABLED, THIS WILL CAUSE PERFORMANCE TO BE REDUCED!", new Object[0]);
        }
        this.fos.write("#requestId;internal rq sequence no;event;component;message\n".getBytes());
    }

    public static void initialize(String traceFileName) throws IOException {
        new Tracer(traceFileName);
    }

    private void writeTraceRecord(String requestId, long intRqSeqNo, TraceEvent event, String component, String message) {
        StringBuffer sb = new StringBuffer();
        if (requestId != null) {
            sb.append(requestId);
        }
        sb.append(';');
        sb.append(intRqSeqNo);
        sb.append(';');
        sb.append(event.getEventType());
        sb.append(';');
        if (component != null) {
            sb.append(component);
        }
        sb.append(';');
        if (message != null) {
            sb.append(message);
        }
        sb.append("\n");
        try {
            this.fos.write(sb.toString().getBytes());
        }
        catch (IOException ex) {
            Logging.logError(3, this, ex);
        }
    }

    public static void trace(String requestId, long intRqSeqNo, TraceEvent event, String component, String message) {
        assert (theInstance != null) : "Tracer not initialized";
        theInstance.writeTraceRecord(requestId, intRqSeqNo, event, component, message);
    }

    public void finalize() {
        try {
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static enum TraceEvent {
        RECEIVED('>'),
        RESPONSE_SENT('<'),
        ERROR_SENT('E');

        private final char eventType;

        private TraceEvent(char eventType) {
            this.eventType = eventType;
        }

        public char getEventType() {
            return this.eventType;
        }
    }
}

