/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.util;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xtreemfs.foundation.util.PBRPCServiceURL;

public class CLIParser {
    public static void parseCLI(String[] args, Map<String, CliOption> options, List<String> arguments) throws IllegalArgumentException {
        List<String> argList = Arrays.asList(args);
        Iterator<String> iter = argList.iterator();
        while (iter.hasNext()) {
            String arg = iter.next().trim();
            if (arg.startsWith("-")) {
                String optName = arg.substring(1);
                CliOption option = options.get(optName);
                if (option == null) {
                    throw new IllegalArgumentException(arg + " is not a valid option");
                }
                switch (option.optType) {
                    case SWITCH: {
                        option.switchValue = true;
                        break;
                    }
                    case STRING: {
                        String value;
                        if (iter.hasNext()) {
                            value = iter.next();
                            option.stringValue = value.trim();
                            break;
                        }
                        throw new IllegalArgumentException(arg + " requires a string argument");
                    }
                    case NUMBER: {
                        String value;
                        if (iter.hasNext()) {
                            value = iter.next();
                            try {
                                option.numValue = Long.valueOf(value.trim());
                                break;
                            }
                            catch (NumberFormatException ex) {
                                throw new IllegalArgumentException(arg + " requires a integer argument and " + value + " is not an integer");
                            }
                        }
                        throw new IllegalArgumentException(arg + " requires a string argument");
                    }
                    case URL: {
                        Object tmp;
                        String value;
                        if (iter.hasNext()) {
                            value = iter.next();
                            try {
                                option.urlValue = tmp = new PBRPCServiceURL(value, option.urlDefaultProtocol, option.urlDefaultPort);
                                break;
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException(ex);
                            }
                        }
                        throw new IllegalArgumentException(arg + " requires a string argument");
                    }
                    case FILE: {
                        Object tmp;
                        String value;
                        if (iter.hasNext()) {
                            value = iter.next();
                            try {
                                tmp = new File(value);
                                option.fileValue = tmp;
                                break;
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException(arg + " requires <protocol>://<host>:<port>");
                            }
                        }
                        throw new IllegalArgumentException(arg + " requires a string argument");
                    }
                }
                continue;
            }
            arguments.add(arg);
        }
    }

    public static final class CliOption {
        public final OPTIONTYPE optType;
        public Boolean switchValue;
        public String stringValue;
        public Long numValue;
        public PBRPCServiceURL urlValue;
        public File fileValue;
        public String urlDefaultProtocol;
        public int urlDefaultPort;
        public String usageParams;
        public String usageText;

        public CliOption(OPTIONTYPE oType) {
            this.optType = oType;
            if (this.optType == OPTIONTYPE.SWITCH) {
                this.switchValue = new Boolean(false);
            }
        }

        public CliOption(OPTIONTYPE oType, String usageText, String usageParams) {
            this(oType);
            this.usageText = usageText;
            this.usageParams = usageParams == null ? "" : usageParams;
        }

        public static enum OPTIONTYPE {
            NUMBER,
            STRING,
            SWITCH,
            URL,
            FILE;

        }
    }
}

