/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.util;

import java.net.MalformedURLException;
import org.xtreemfs.foundation.util.PBRPCServiceURL;

public abstract class CLOption {
    protected String shortName;
    protected String longName;
    protected String helpText;
    protected boolean set;

    public CLOption(String shortName, String longName, String helpText) {
        this.shortName = shortName;
        this.longName = longName;
        this.helpText = helpText;
        if (shortName == null && longName == null) {
            throw new IllegalArgumentException("must specify either a shortName or a longName or both");
        }
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (this.shortName != null) {
            sb.append("-");
            sb.append(this.shortName);
            if (this.longName != null) {
                sb.append("/");
            } else {
                sb.append(" ");
            }
        }
        if (this.longName != null) {
            sb.append("--");
            sb.append(this.longName);
            sb.append("=");
        }
        return sb.toString();
    }

    public String getName(boolean useShortName) {
        if (useShortName) {
            return this.shortName;
        }
        return this.longName;
    }

    public abstract String getHelp();

    public void parse(String value) throws IllegalArgumentException {
        this.set = true;
    }

    public boolean isSet() {
        return this.set;
    }

    public abstract boolean requiresArgument();

    public String toString() {
        return this.getHelp();
    }

    public static class URLValue
    extends CLOption {
        protected PBRPCServiceURL value;
        protected final String defaultSchema;
        protected final int defaultPort;

        public URLValue(String shortName, String longName, String helpText, String defaultSchema, int defaultPort) {
            super(shortName, longName, helpText);
            this.defaultSchema = defaultSchema;
            this.defaultPort = defaultPort;
        }

        @Override
        public String getHelp() {
            return this.getName() + "[<schema>://]<hostname>[:<port>] " + this.helpText + " (default schema is " + this.defaultSchema + ", default port is " + this.defaultPort + ")";
        }

        @Override
        public void parse(String value) throws IllegalArgumentException {
            super.parse(value);
            try {
                this.value = new PBRPCServiceURL(value, this.defaultSchema, this.defaultPort);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("'" + value + "' is not a valid URL (" + ex.getMessage() + ")");
            }
        }

        @Override
        public boolean requiresArgument() {
            return true;
        }

        public PBRPCServiceURL getValue() {
            return this.value;
        }
    }

    public static class IntegerValue
    extends CLOption {
        protected int value;

        public IntegerValue(String shortName, String longName, String helpText) {
            super(shortName, longName, helpText);
        }

        @Override
        public String getHelp() {
            return this.getName() + "<number> " + this.helpText;
        }

        @Override
        public void parse(String value) throws IllegalArgumentException {
            super.parse(value);
            try {
                this.value = Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("'" + value + "' is not a valid number");
            }
        }

        @Override
        public boolean requiresArgument() {
            return true;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class StringValue
    extends CLOption {
        protected String value;

        public StringValue(String shortName, String longName, String helpText) {
            super(shortName, longName, helpText);
        }

        @Override
        public String getHelp() {
            return this.getName() + "<string> " + this.helpText;
        }

        @Override
        public void parse(String value) throws IllegalArgumentException {
            super.parse(value);
            this.value = value;
        }

        @Override
        public boolean requiresArgument() {
            return true;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Switch
    extends CLOption {
        protected boolean value;

        public Switch(String shortName, String longName, String helpText) {
            super(shortName, longName, helpText);
        }

        @Override
        public String getHelp() {
            return this.getName() + this.helpText;
        }

        @Override
        public void parse(String value) throws IllegalArgumentException {
            super.parse(value);
            this.value = true;
        }

        @Override
        public boolean requiresArgument() {
            return false;
        }

        public boolean getValue() {
            return this.value;
        }
    }
}

