/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.util;

import java.util.LinkedList;
import java.util.List;
import org.xtreemfs.foundation.util.CLOption;

public class CLOptionParser {
    private final String programName;
    private final List<CLOption> options;
    private final List<String> arguments;

    public CLOptionParser(String programName) {
        this.programName = programName;
        this.options = new LinkedList<CLOption>();
        this.arguments = new LinkedList<String>();
    }

    public CLOption addOption(CLOption option) {
        CLOption rv = option;
        for (CLOption tmp : this.options) {
            if (tmp.getName(true) != null && !tmp.getName(true).equals(option.getName(true)) || tmp.getName(false) != null && !tmp.getName(false).equals(option.getName(false))) continue;
            rv = tmp;
            break;
        }
        if (rv == option) {
            this.options.add(option);
        }
        return rv;
    }

    public void printUsage(String arguments) {
        System.out.println(this.programName + " [options] " + arguments);
        this.printOptionHelp();
        System.out.println("");
    }

    public void printOptionHelp() {
        for (CLOption option : this.options) {
            System.out.println("\t" + option.getHelp());
        }
    }

    public void parse(String[] args) throws IllegalArgumentException {
        boolean nextIsValue = false;
        CLOption currentOption = null;
        for (int position = 0; position < args.length; ++position) {
            if (nextIsValue) {
                assert (currentOption != null);
                currentOption.parse(args[position]);
                currentOption = null;
                nextIsValue = false;
                continue;
            }
            if (args[position].charAt(0) == '-') {
                String name;
                boolean useShortName;
                String value = null;
                if (args[position].charAt(1) == '-') {
                    useShortName = false;
                    name = args[position].substring(2);
                    if (name.length() == 0) {
                        throw new IllegalArgumentException("-- is not a valid option");
                    }
                    int posEq = name.indexOf("=");
                    if (posEq >= 0) {
                        value = name.substring(posEq + 1);
                        name = name.substring(0, posEq);
                    }
                } else {
                    useShortName = true;
                    name = args[position].substring(1);
                    if (name.length() == 0) {
                        throw new IllegalArgumentException("- is not a valid option");
                    }
                }
                boolean optFound = false;
                for (CLOption option : this.options) {
                    String optName = option.getName(useShortName);
                    if (optName == null || !optName.equals(name)) continue;
                    if (option.requiresArgument()) {
                        if (value == null) {
                            currentOption = option;
                            nextIsValue = true;
                        } else {
                            option.parse(value);
                        }
                    } else {
                        option.parse(null);
                    }
                    optFound = true;
                    break;
                }
                if (optFound) continue;
                throw new IllegalArgumentException("'" + args[position] + "' is not a valid option");
            }
            this.arguments.add(args[position]);
        }
        if (nextIsValue) {
            throw new IllegalArgumentException("expected value for option '" + currentOption.getName() + "'");
        }
    }

    public List<String> getArguments() {
        return this.arguments;
    }
}

