/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

public class FSUtils {
    public static void delTree(File file) {
        if (!file.exists()) {
            return;
        }
        File[] fileList = file.listFiles();
        if (fileList != null) {
            for (File f : fileList) {
                if (f.isDirectory()) {
                    FSUtils.delTree(f);
                    continue;
                }
                f.delete();
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTree(File srcFile, File trgFile) throws IOException {
        if (srcFile.isDirectory()) {
            trgFile.mkdir();
            for (File file : srcFile.listFiles()) {
                FSUtils.copyTree(file, new File(trgFile, file.getName()));
            }
        } else {
            FileChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                in = new FileInputStream(srcFile).getChannel();
                out = new FileOutputStream(trgFile).getChannel();
                in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static long getFreeSpace(String dir) {
        return new File(dir).getFreeSpace();
    }

    public static long getUsableSpace(String dir) {
        return new File(dir).getUsableSpace();
    }

    public static File[] listRecursively(File rootDir, FileFilter filter) {
        ArrayList<File> list = new ArrayList<File>();
        FSUtils.listRecursively(rootDir, filter, list);
        return list.toArray(new File[list.size()]);
    }

    private static void listRecursively(File rootDir, FileFilter filter, List<File> list) {
        File[] nestedDirs;
        if (!rootDir.exists()) {
            return;
        }
        for (File dir : nestedDirs = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            FSUtils.listRecursively(dir, filter, list);
        }
        for (File f : rootDir.listFiles(filter)) {
            list.add(f);
        }
    }
}

