/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public final class OutputUtils {
    public static final char[] trHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final byte[] fromHex = new byte[128];

    public static final String byteToHexString(byte b) {
        StringBuilder sb = new StringBuilder(2);
        sb.append(trHex[b >> 4 & 0xF]);
        sb.append(trHex[b & 0xF]);
        return sb.toString();
    }

    public static final String byteArrayToHexString(byte[] array) {
        StringBuilder sb = new StringBuilder(2 * array.length);
        for (byte b : array) {
            sb.append(trHex[b >> 4 & 0xF]);
            sb.append(trHex[b & 0xF]);
        }
        return sb.toString();
    }

    public static final String byteArrayToFormattedHexString(byte[] array) {
        return OutputUtils.byteArrayToFormattedHexString(array, 0, array.length);
    }

    public static final String byteArrayToFormattedHexString(byte[] array, int offset, int len) {
        StringBuilder sb = new StringBuilder(2 * len);
        for (int i = offset; i < offset + len; ++i) {
            sb.append(trHex[array[i] >> 4 & 0xF]);
            sb.append(trHex[array[i] & 0xF]);
            if ((i - offset) % 4 != 3) continue;
            if ((i - offset) % 16 == 15) {
                sb.append("\n");
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String stackTraceToString(Throwable th) {
        PrintStream ps = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ps = new PrintStream(out);
            if (th != null) {
                th.printStackTrace(ps);
            }
            String string = new String(out.toByteArray());
            return string;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public static String formatBytes(long bytes) {
        double kb = (double)bytes / 1024.0;
        double mb = (double)bytes / 1048576.0;
        double gb = (double)bytes / 1.073741824E9;
        double tb = (double)bytes / 1.099511627776E12;
        if (tb >= 1.0) {
            return String.format("%.2f TB", tb);
        }
        if (gb >= 1.0) {
            return String.format("%.2f GB", gb);
        }
        if (mb >= 1.0) {
            return String.format("%.2f MB", mb);
        }
        if (kb >= 1.0) {
            return String.format("%.2f kB", kb);
        }
        return bytes + " bytes";
    }

    public static String escapeToXML(String st) {
        st = st.replace("&", "&amp;");
        st = st.replace("'", "&apos;");
        st = st.replace("<", "&lt;");
        st = st.replace(">", "&gt;");
        st = st.replace("\"", "&quot;");
        return st;
    }

    public static String unescapeFromXML(String st) {
        st = st.replace("&amp;", "&");
        st = st.replace("&apos;", "'");
        st = st.replace("&lt;", "<");
        st = st.replace("&gt;", ">");
        st = st.replace("&quot;", "\"");
        return st;
    }

    public static String encodeBase64(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes));
    }

    public static byte[] decodeBase64(String s) throws IOException {
        return Base64.decodeBase64((byte[])s.getBytes());
    }

    public static byte[] hexStringToByteArray(String hexString) {
        assert (hexString.length() % 2 == 0);
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            int b = Integer.parseInt(hexString.substring(i, i + 2), 16);
            bytes[i / 2] = b >= 128 ? (byte)(b - 256) : (byte)b;
        }
        return bytes;
    }

    public static void writeHexInt(StringBuffer sb, int value) {
        sb.append(trHex[value & 0xF]);
        sb.append(trHex[value >> 4 & 0xF]);
        sb.append(trHex[value >> 8 & 0xF]);
        sb.append(trHex[value >> 12 & 0xF]);
        sb.append(trHex[value >> 16 & 0xF]);
        sb.append(trHex[value >> 20 & 0xF]);
        sb.append(trHex[value >> 24 & 0xF]);
        sb.append(trHex[value >> 28 & 0xF]);
    }

    public static void writeHexLong(StringBuffer sb, long value) {
        OutputUtils.writeHexInt(sb, (int)(value & 0xFFFFFFFFFFFFFFFFL));
        OutputUtils.writeHexInt(sb, (int)(value >> 32));
    }

    public static int readHexInt(String str, int position) {
        int value = fromHex[str.charAt(position)];
        value += fromHex[str.charAt(position + 1)] << 4;
        value += fromHex[str.charAt(position + 2)] << 8;
        value += fromHex[str.charAt(position + 3)] << 12;
        value += fromHex[str.charAt(position + 4)] << 16;
        value += fromHex[str.charAt(position + 5)] << 20;
        value += fromHex[str.charAt(position + 6)] << 24;
        return value += fromHex[str.charAt(position + 7)] << 28;
    }

    public static long readHexLong(String str, int position) {
        int low = OutputUtils.readHexInt(str, position);
        int high = OutputUtils.readHexInt(str, position + 8);
        long value = (long)high << 32 | (long)low & 0xFFFFFFFFL;
        return value;
    }

    public static String getThreadDump() {
        StringBuilder sb = new StringBuilder();
        sb.append("<HTML><BODY><H1>THREAD STATES</H1><PRE>");
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        for (Thread t : traces.keySet()) {
            sb.append("<B>thread: ");
            sb.append(t.getName());
            sb.append("</B>\n");
            StackTraceElement[] elems = traces.get(t);
            for (int i = elems.length - 1; i >= 0; --i) {
                sb.append(elems[i].toString());
                sb.append("\n");
            }
            sb.append("\n");
        }
        sb.append("</PRE></BODY></HTML>");
        return sb.toString();
    }

    public static String SecondsToString(long seconds) {
        String timeString = null;
        timeString = seconds < 60L ? seconds + " seconds" : (seconds < 3600L ? seconds / 60L + " minutes" : (seconds < 86400L ? seconds / 3600L + " hours" : seconds / 86400L + " days"));
        return timeString;
    }

    static {
        OutputUtils.fromHex[48] = 0;
        OutputUtils.fromHex[49] = 1;
        OutputUtils.fromHex[50] = 2;
        OutputUtils.fromHex[51] = 3;
        OutputUtils.fromHex[52] = 4;
        OutputUtils.fromHex[53] = 5;
        OutputUtils.fromHex[54] = 6;
        OutputUtils.fromHex[55] = 7;
        OutputUtils.fromHex[56] = 8;
        OutputUtils.fromHex[57] = 9;
        OutputUtils.fromHex[65] = 10;
        OutputUtils.fromHex[97] = 10;
        OutputUtils.fromHex[66] = 11;
        OutputUtils.fromHex[98] = 11;
        OutputUtils.fromHex[67] = 12;
        OutputUtils.fromHex[99] = 12;
        OutputUtils.fromHex[68] = 13;
        OutputUtils.fromHex[100] = 13;
        OutputUtils.fromHex[69] = 14;
        OutputUtils.fromHex[101] = 14;
        OutputUtils.fromHex[70] = 15;
        OutputUtils.fromHex[102] = 15;
    }
}

