/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.util;

import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PBRPCServiceURL {
    private static final Pattern urlPattern = Pattern.compile("((pbrpc[gs]?):\\/\\/)?([^:]+)(:([0-9]+))?/?");
    private final String protocol;
    private final String host;
    private final int port;

    public PBRPCServiceURL(String url, String defaultProtocol, int defaultPort) throws MalformedURLException {
        Matcher m = urlPattern.matcher(url);
        if (m.matches()) {
            this.protocol = m.group(2) != null ? m.group(2) : defaultProtocol;
            this.host = m.group(3);
            this.port = m.group(4) != null ? Integer.valueOf(m.group(4).substring(1)) : defaultPort;
        } else {
            throw new MalformedURLException("'" + url + "' is not a valid XtreemFS service URL");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.protocol + "://" + this.host + ":" + this.port;
    }
}

