/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.foundation.util;

import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.Ping;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCNIOSocketServer;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequestListener;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferInputStream;
import org.xtreemfs.foundation.util.OutputUtils;

public class PingServer {
    public static final String CERT_DIR = "../../tests/certs/";

    public static void main(String[] args) {
        try {
            Logging.start(7, Logging.Category.all);
            SSLOptions ssl = null;
            ssl = new SSLOptions(new FileInputStream("../../tests/certs/Client.p12"), "passphrase", "PKCS12", new FileInputStream("../../tests/certs/trusted.jks"), "passphrase", "JKS", false, true, null, null);
            RPCNIOSocketServer server = new RPCNIOSocketServer(12345, null, new RPCServerRequestListener(){
                int cnt = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receiveRecord(RPCServerRequest rq) {
                    try {
                        ReusableBufferInputStream is = new ReusableBufferInputStream(rq.getMessage());
                        Ping.PingRequest pingRq = Ping.PingRequest.parseFrom(is);
                        Ping.PingResponse resp = null;
                        if (pingRq.getSendError()) {
                            resp = Ping.PingResponse.newBuilder().setError(Ping.PingResponse.PingError.newBuilder().setErrorMessage("error message")).build();
                        } else {
                            Ping.PingResponse.PingResult result = Ping.PingResponse.PingResult.newBuilder().setText(pingRq.getText()).build();
                            resp = Ping.PingResponse.newBuilder().setResult(result).build();
                        }
                        ReusableBuffer data = null;
                        if (rq.getData() != null) {
                            data = rq.getData().createViewBuffer();
                            data.limit(data.capacity());
                            data.position(data.capacity());
                        }
                        rq.sendResponse(resp, data);
                        ++this.cnt;
                        if (this.cnt % 1000 == 0) {
                            System.out.println(BufferPool.getStatus());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        rq.sendError(RPC.RPCHeader.ErrorResponse.newBuilder().setErrorType(RPC.ErrorType.GARBAGE_ARGS).setErrorMessage(ex.getMessage()).setDebugInfo(OutputUtils.stackTraceToString(ex)).build());
                    }
                    finally {
                        rq.freeBuffers();
                    }
                }
            }, ssl);
            server.start();
            server.waitForStartup();
            System.out.println("PING server running");
        }
        catch (Exception ex) {
            Logger.getLogger(PingServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

