/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc;

import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.OutputUtils;

public final class ErrorRecord {
    private final RPC.ErrorType type;
    private final RPC.POSIXErrno errno;
    private final String message;
    private final Throwable throwable;

    public ErrorRecord(RPC.ErrorType type, RPC.POSIXErrno errno, String message) {
        this(type, errno, message, null);
    }

    public ErrorRecord(RPC.ErrorType type, RPC.POSIXErrno errno, String message, Throwable throwable) {
        this.type = type;
        this.errno = errno;
        this.message = message;
        this.throwable = throwable;
    }

    public RPC.POSIXErrno getErrorCode() {
        return this.errno;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public RPC.ErrorType getErrorType() {
        return this.type;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getStackTrace() {
        return OutputUtils.stackTraceToString(this.throwable);
    }

    public String toString() {
        String stackTrace = OutputUtils.stackTraceToString(this.throwable);
        return this.type + "." + this.errno + ":" + this.message + (stackTrace == null ? "" : ", caused by: " + stackTrace);
    }

    public String toJSON() {
        return "{ \"errno\": " + this.errno + ", \"errorMessage\" : \"" + this.message.replace("\"", "\\\"") + "\" }";
    }
}

