/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc;

import java.io.IOException;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.MRCConfig;
import org.xtreemfs.mrc.MRCRequestDispatcher;

public class MRC {
    private MRCRequestDispatcher rc;

    public MRC(MRCConfig config, BabuDBConfig dbConfig) {
        block5: {
            if (Logging.isInfo()) {
                Logging.logMessage(6, Logging.Category.misc, (Object)null, "JAVA_HOME=%s", System.getProperty("java.home"));
                Logging.logMessage(6, Logging.Category.misc, (Object)null, "UUID: %s", config.getUUID().toString());
            }
            try {
                this.rc = new MRCRequestDispatcher(config, dbConfig);
                this.rc.startup();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            if (Logging.isInfo()) {
                                Logging.logMessage(6, Logging.Category.lifecycle, this, "received shutdown signal!", new Object[0]);
                            }
                            MRC.this.rc.shutdown();
                            if (Logging.isInfo()) {
                                Logging.logMessage(6, Logging.Category.lifecycle, this, "MRC shutdown complete", new Object[0]);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception ex) {
                Logging.logMessage(2, null, "MRC could not start up due to an exception. Aborted.", new Object[0]);
                Logging.logError(2, null, ex);
                if (this.rc == null) break block5;
                try {
                    this.rc.shutdown();
                }
                catch (Exception e) {
                    Logging.logMessage(3, config.getUUID(), "could not shutdown MRC: ", new Object[0]);
                    Logging.logError(3, config.getUUID(), e);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Thread.currentThread().setName("MRC");
        String configFileName = "etc/xos/xtreemfs/mrcconfig.test";
        configFileName = args.length == 1 ? args[0] : configFileName;
        MRCConfig config = new MRCConfig(configFileName);
        config.setDefaults();
        config.checkConfig();
        BabuDBConfig dbsConfig = null;
        try {
            dbsConfig = new BabuDBConfig(configFileName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        Logging.start(config.getDebugLevel(), config.getDebugCategories());
        new MRC(config, dbsConfig);
    }
}

