/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.xtreemfs.common.config.ServiceConfig;

public class MRCConfig
extends ServiceConfig {
    final ServiceConfig.Parameter[] mrcParameter = new ServiceConfig.Parameter[]{ServiceConfig.Parameter.DEBUG_LEVEL, ServiceConfig.Parameter.DEBUG_CATEGORIES, ServiceConfig.Parameter.PORT, ServiceConfig.Parameter.HTTP_PORT, ServiceConfig.Parameter.LISTEN_ADDRESS, ServiceConfig.Parameter.HOSTNAME, ServiceConfig.Parameter.OSD_CHECK_INTERVAL, ServiceConfig.Parameter.DIRECTORY_SERVICE, ServiceConfig.Parameter.NOATIME, ServiceConfig.Parameter.LOCAL_CLOCK_RENEW, ServiceConfig.Parameter.REMOTE_TIME_SYNC, ServiceConfig.Parameter.USE_SSL, ServiceConfig.Parameter.SSL_PROTOCOL_STRING, ServiceConfig.Parameter.SERVICE_CREDS_FILE, ServiceConfig.Parameter.SERVICE_CREDS_PASSPHRASE, ServiceConfig.Parameter.SERVICE_CREDS_CONTAINER, ServiceConfig.Parameter.TRUSTED_CERTS_FILE, ServiceConfig.Parameter.TRUSTED_CERTS_CONTAINER, ServiceConfig.Parameter.TRUSTED_CERTS_PASSPHRASE, ServiceConfig.Parameter.TRUST_MANAGER, ServiceConfig.Parameter.USE_GRID_SSL_MODE, ServiceConfig.Parameter.UUID, ServiceConfig.Parameter.WAIT_FOR_DIR, ServiceConfig.Parameter.GEO_COORDINATES, ServiceConfig.Parameter.AUTHENTICATION_PROVIDER, ServiceConfig.Parameter.POLICY_DIR, ServiceConfig.Parameter.CAPABILITY_SECRET, ServiceConfig.Parameter.CAPABILITY_TIMEOUT, ServiceConfig.Parameter.ADMIN_PASSWORD, ServiceConfig.Parameter.RENEW_TIMED_OUT_CAPS, ServiceConfig.Parameter.USE_SNMP, ServiceConfig.Parameter.SNMP_ADDRESS, ServiceConfig.Parameter.SNMP_PORT, ServiceConfig.Parameter.SNMP_ACL, ServiceConfig.Parameter.FAILOVER_MAX_RETRIES, ServiceConfig.Parameter.FAILOVER_WAIT, ServiceConfig.Parameter.USE_RENEWAL_SIGNAL, ServiceConfig.Parameter.USE_MULTIHOMING, ServiceConfig.Parameter.FLEASE_LEASE_TIMEOUT_MS};

    public MRCConfig(String filename) throws IOException {
        super(filename);
        this.read();
    }

    public MRCConfig(Properties prop) throws IOException {
        super(prop);
        this.read();
    }

    public MRCConfig(HashMap<String, String> hm) {
        super(hm);
    }

    public void read() throws IOException {
        for (ServiceConfig.Parameter parm : this.mrcParameter) {
            this.parameter.put(parm, this.readParameter(parm));
        }
    }

    public int getOsdCheckInterval() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.OSD_CHECK_INTERVAL);
    }

    public boolean isNoAtime() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.NOATIME);
    }

    public int getLocalClockRenew() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.LOCAL_CLOCK_RENEW);
    }

    public int getRemoteTimeSync() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.REMOTE_TIME_SYNC);
    }

    public String getAuthenticationProvider() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.AUTHENTICATION_PROVIDER);
    }

    public String getCapabilitySecret() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.CAPABILITY_SECRET);
    }

    public int getCapabilityTimeout() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.CAPABILITY_TIMEOUT);
    }

    public boolean isRenewTimedOutCaps() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.RENEW_TIMED_OUT_CAPS);
    }

    public void setDefaults() {
        super.setDefaults(this.mrcParameter);
    }

    public void checkConfig() {
        super.checkConfig(this.mrcParameter);
        this.checkMultihomingConfiguration();
    }

    public int getFleaseLeaseToMS() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.FLEASE_LEASE_TIMEOUT_MS);
    }
}

