/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc;

import java.io.IOException;
import org.xtreemfs.common.auth.AuthenticationProvider;
import org.xtreemfs.common.config.PolicyClassLoader;
import org.xtreemfs.common.config.PolicyContainer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.MRCConfig;
import org.xtreemfs.mrc.MRCException;
import org.xtreemfs.mrc.ac.FileAccessPolicy;
import org.xtreemfs.mrc.ac.POSIXFileAccessPolicy;
import org.xtreemfs.mrc.ac.VolumeACLFileAccessPolicy;
import org.xtreemfs.mrc.ac.YesToAnyoneFileAccessPolicy;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.osdselection.FilterDefaultPolicy;
import org.xtreemfs.mrc.osdselection.FilterFQDNPolicy;
import org.xtreemfs.mrc.osdselection.FilterUUIDPolicy;
import org.xtreemfs.mrc.osdselection.GroupDCMapPolicy;
import org.xtreemfs.mrc.osdselection.GroupFQDNPolicy;
import org.xtreemfs.mrc.osdselection.OSDSelectionPolicy;
import org.xtreemfs.mrc.osdselection.SortDCMapPolicy;
import org.xtreemfs.mrc.osdselection.SortFQDNPolicy;
import org.xtreemfs.mrc.osdselection.SortHostRoundRobinPolicy;
import org.xtreemfs.mrc.osdselection.SortRandomPolicy;
import org.xtreemfs.mrc.osdselection.SortReversePolicy;
import org.xtreemfs.mrc.osdselection.SortUUIDPolicy;
import org.xtreemfs.mrc.osdselection.SortVivaldiPolicy;

public class MRCPolicyContainer
extends PolicyContainer {
    private static final String[] POLICY_INTERFACES = new String[]{FileAccessPolicy.class.getName(), OSDSelectionPolicy.class.getName()};
    private static final String[] BUILT_IN_POLICIES = new String[]{POSIXFileAccessPolicy.class.getName(), VolumeACLFileAccessPolicy.class.getName(), YesToAnyoneFileAccessPolicy.class.getName(), FilterDefaultPolicy.class.getName(), FilterFQDNPolicy.class.getName(), FilterUUIDPolicy.class.getName(), GroupDCMapPolicy.class.getName(), GroupFQDNPolicy.class.getName(), SortDCMapPolicy.class.getName(), SortFQDNPolicy.class.getName(), SortRandomPolicy.class.getName(), SortVivaldiPolicy.class.getName(), SortUUIDPolicy.class.getName(), SortReversePolicy.class.getName(), SortHostRoundRobinPolicy.class.getName()};
    private final MRCConfig config;

    public MRCPolicyContainer(MRCConfig config) throws IOException {
        super(config, new PolicyClassLoader(config.getPolicyDir(), POLICY_INTERFACES, BUILT_IN_POLICIES));
        this.config = config;
    }

    public AuthenticationProvider getAuthenticationProvider() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String authPolicy = this.config.getAuthenticationProvider();
        try {
            return (AuthenticationProvider)Class.forName(authPolicy).newInstance();
        }
        catch (Exception exc) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "no built-in policy '%s' exists, searching for plug-in policies...", this.config.getAuthenticationProvider());
            }
            Class<?> cls = this.policyClassLoader.loadClass(authPolicy);
            return (AuthenticationProvider)cls.newInstance();
        }
    }

    public FileAccessPolicy getFileAccessPolicy(short id, VolumeManager volMan) throws Exception {
        try {
            Class<?> policyClass = this.policyClassLoader.loadClass(id, FileAccessPolicy.class);
            if (policyClass == null) {
                throw new MRCException("policy not found");
            }
            try {
                return (FileAccessPolicy)policyClass.newInstance();
            }
            catch (InstantiationException exc) {
                try {
                    return (FileAccessPolicy)policyClass.getConstructor(VolumeManager.class).newInstance(volMan);
                }
                catch (InstantiationException exc2) {
                    throw new InstantiationException("policy " + policyClass + " does not have a suitable constructor");
                }
            }
        }
        catch (Exception exc) {
            Logging.logMessage(4, Logging.Category.misc, this, "could not load FileAccessPolicy with ID %d", id);
            Logging.logMessage(4, Logging.Category.misc, this, OutputUtils.stackTraceToString(exc), new Object[0]);
            throw exc;
        }
    }

    public OSDSelectionPolicy getOSDSelectionPolicy(short id) throws Exception {
        try {
            Class<?> policyClass = this.policyClassLoader.loadClass(id, OSDSelectionPolicy.class);
            if (policyClass == null) {
                throw new MRCException("policy not found");
            }
            return (OSDSelectionPolicy)policyClass.newInstance();
        }
        catch (Exception exc) {
            Logging.logMessage(4, Logging.Category.misc, this, "could not load OSDSelectionPolicy with ID %d", id);
            Logging.logMessage(4, Logging.Category.misc, this, OutputUtils.stackTraceToString(exc), new Object[0]);
            throw exc;
        }
    }
}

