/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.io.IOException;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferInputStream;
import org.xtreemfs.mrc.ErrorRecord;
import org.xtreemfs.mrc.RequestDetails;

public class MRCRequest {
    private final RPCServerRequest rpcRequest;
    private Message requestArgs;
    private GeneratedMessage response;
    private ErrorRecord error;
    private RequestDetails details;

    public MRCRequest() {
        this(null);
    }

    public MRCRequest(RPCServerRequest rpcRequest) {
        this.rpcRequest = rpcRequest;
        this.details = new RequestDetails();
    }

    public RPCServerRequest getRPCRequest() {
        return this.rpcRequest;
    }

    public ErrorRecord getError() {
        return this.error;
    }

    public void deserializeMessage(Message message) throws IOException {
        ReusableBuffer payload = this.rpcRequest.getMessage();
        this.requestArgs = message.newBuilderForType().mergeFrom(new ReusableBufferInputStream(payload)).build();
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "parsed request: %s", this.requestArgs.toString());
        }
    }

    public void setError(RPC.ErrorType type, RPC.POSIXErrno errno, String message, Throwable th) {
        this.error = new ErrorRecord(type, errno, message, th);
    }

    public void setError(RPC.ErrorType type, String message, Throwable th) {
        this.error = new ErrorRecord(type, RPC.POSIXErrno.POSIX_ERROR_NONE, message, th);
    }

    public void setError(RPC.ErrorType type, RPC.POSIXErrno errno, String message) {
        this.error = new ErrorRecord(type, errno, message);
    }

    public void setError(RPC.ErrorType type, String message) {
        this.error = new ErrorRecord(type, RPC.POSIXErrno.POSIX_ERROR_NONE, message);
    }

    public void setError(ErrorRecord error) {
        this.error = error;
    }

    public GeneratedMessage getResponse() {
        return this.response;
    }

    public void setResponse(GeneratedMessage response) {
        this.response = response;
    }

    public Message getRequestArgs() {
        return this.requestArgs;
    }

    public void setRequestArgs(Message requestArgs) {
        this.requestArgs = requestArgs;
    }

    public RequestDetails getDetails() {
        return this.details;
    }

    public void setDetails(RequestDetails details) {
        this.details = details;
    }

    public String toString() {
        if (this.rpcRequest == null) {
            return null;
        }
        return this.rpcRequest.toString();
    }
}

