/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.common.HeartbeatThread;
import org.xtreemfs.common.auth.AuthenticationProvider;
import org.xtreemfs.common.config.RemoteConfigHelper;
import org.xtreemfs.common.config.ServiceConfig;
import org.xtreemfs.common.monitoring.StatusMonitor;
import org.xtreemfs.common.statusserver.BabuDBStatusPage;
import org.xtreemfs.common.statusserver.PrintStackTrace;
import org.xtreemfs.common.statusserver.StatusServer;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UUIDResolver;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.dir.DIRClient;
import org.xtreemfs.dir.discovery.DiscoveryUtils;
import org.xtreemfs.foundation.CrashReporter;
import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.Schemes;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCNIOSocketServer;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequestListener;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.ErrorRecord;
import org.xtreemfs.mrc.MRCConfig;
import org.xtreemfs.mrc.MRCException;
import org.xtreemfs.mrc.MRCPolicyContainer;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCStatusListener;
import org.xtreemfs.mrc.MRCStatusManager;
import org.xtreemfs.mrc.StatusPage;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.DBAccessResultListener;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.database.babudb.BabuDBVolumeManager;
import org.xtreemfs.mrc.metadata.StripingPolicy;
import org.xtreemfs.mrc.osdselection.OSDStatusManager;
import org.xtreemfs.mrc.stages.OnCloseReplicationThread;
import org.xtreemfs.mrc.stages.ProcessingStage;
import org.xtreemfs.mrc.stages.XLocSetCoordinator;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.DIRServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class MRCRequestDispatcher
implements RPCServerRequestListener,
LifeCycleListener,
DBAccessResultListener<Object> {
    private static final int RPC_TIMEOUT = 15000;
    private static final int CONNECTION_TIMEOUT = 300000;
    private final RPCNIOSocketServer serverStage;
    private final RPCNIOSocketClient clientStage;
    private final DIRClient dirClient;
    private final ProcessingStage procStage;
    private final MRCStatusManager mrcMonitor;
    private final OSDStatusManager osdMonitor;
    private final MRCPolicyContainer policyContainer;
    private final AuthenticationProvider authProvider;
    private final MRCConfig config;
    private final HeartbeatThread heartbeatThread;
    private final OnCloseReplicationThread onCloseReplicationThread;
    private final VolumeManager volumeManager;
    private final FileAccessManager fileAccessManager;
    private final StatusServer statusServer;
    private final OSDServiceClient osdClient;
    private final boolean replicated;
    private List<MRCStatusListener> statusListener;
    private final XLocSetCoordinator xLocSetCoordinator;
    private final long initTimeMS = System.currentTimeMillis();

    public MRCRequestDispatcher(final MRCConfig config, BabuDBConfig dbConfig) throws Exception {
        InetSocketAddress bindPoint;
        Logging.logMessage(6, this, "XtreemFS Metadata Service version 1.5.0-master", new Object[0]);
        this.config = config;
        if (this.config.getDirectoryService().getHostName().equals(".autodiscover")) {
            Logging.logMessage(6, Logging.Category.net, this, "trying to discover local XtreemFS DIR service...", new Object[0]);
            DIR.DirService dir = DiscoveryUtils.discoverDir(10);
            if (dir == null) {
                Logging.logMessage(3, Logging.Category.net, this, "CANNOT FIND XtreemFS DIR service via discovery broadcasts... no response", new Object[0]);
                throw new IOException("no DIR service found via discovery broadcast");
            }
            Logging.logMessage(6, Logging.Category.net, this, "found XtreemFS DIR service at " + dir.getAddress() + ":" + dir.getPort(), new Object[0]);
            config.setDirectoryService(new InetSocketAddress(dir.getAddress(), dir.getPort()));
        }
        if (config.isInitializable().booleanValue()) {
            try {
                ServiceConfig remoteConfig = RemoteConfigHelper.getConfigurationFromDIR(config);
                config.mergeConfig(remoteConfig);
            }
            catch (Exception e) {
                Logging.logMessage(4, this, "Couldn't fetch configuration from DIR. Reason: " + e.getMessage(), new Object[0]);
                Logging.logError(7, this, e);
            }
        }
        if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.misc, this, "use SSL=%b", config.isUsingSSL());
        }
        this.policyContainer = new MRCPolicyContainer(config);
        if (Logging.isInfo() && config.isUsingSSL() && this.policyContainer.getTrustManager() != null) {
            Logging.logMessage(6, Logging.Category.misc, this, "using custom trust manager '%s'", this.policyContainer.getTrustManager().getClass().getName());
        }
        SSLOptions sslOptions = config.isUsingSSL() ? new SSLOptions(new FileInputStream(config.getServiceCredsFile()), config.getServiceCredsPassphrase(), config.getServiceCredsContainer(), new FileInputStream(config.getTrustedCertsFile()), config.getTrustedCertsPassphrase(), config.getTrustedCertsContainer(), false, config.isGRIDSSLmode(), config.getSSLProtocolString(), this.policyContainer.getTrustManager()) : null;
        InetSocketAddress inetSocketAddress = bindPoint = config.getAddress() != null ? new InetSocketAddress(config.getAddress(), 0) : null;
        if (Logging.isInfo() && bindPoint != null) {
            Logging.logMessage(6, Logging.Category.misc, this, "outgoing server connections will be bound to '%s'", config.getAddress());
        }
        this.clientStage = new RPCNIOSocketClient(sslOptions, 15000, 300000, -1, -1, bindPoint, "MRCRequestDispatcher");
        this.clientStage.setLifeCycleListener(this);
        this.serverStage = new RPCNIOSocketServer(config.getPort(), config.getAddress(), this, sslOptions);
        this.serverStage.setLifeCycleListener(this);
        DIRServiceClient dirRpcClient = new DIRServiceClient(this.clientStage, config.getDirectoryService());
        this.dirClient = new DIRClient(dirRpcClient, config.getDirectoryServices(), config.getFailoverMaxRetries(), config.getFailoverWait());
        this.osdClient = new OSDServiceClient(this.clientStage, null);
        TimeSync.initialize(this.dirClient, config.getRemoteTimeSync(), config.getLocalClockRenew());
        this.authProvider = this.policyContainer.getAuthenticationProvider();
        this.authProvider.initialize(config.isUsingSSL());
        if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.misc, this, "using authentication provider '%s'", this.authProvider.getClass().getName());
        }
        this.osdMonitor = new OSDStatusManager(this);
        this.osdMonitor.setLifeCycleListener(this);
        this.xLocSetCoordinator = new XLocSetCoordinator(this);
        this.xLocSetCoordinator.setLifeCycleListener(this);
        this.procStage = new ProcessingStage(this);
        this.volumeManager = new BabuDBVolumeManager(this, dbConfig);
        this.fileAccessManager = new FileAccessManager(this.volumeManager, this.policyContainer);
        this.statusListener = new ArrayList<MRCStatusListener>();
        if (config.isUsingSnmp().booleanValue()) {
            this.statusListener.add(new StatusMonitor(this, config.getSnmpAddress(), (int)config.getSnmpPort(), config.getSnmpACLFile()));
            this.notifyConfigurationChange();
        }
        this.replicated = dbConfig.getPlugins().size() > 0;
        HeartbeatThread.ServiceDataGenerator gen = new HeartbeatThread.ServiceDataGenerator(){

            @Override
            public DIR.ServiceSet getServiceData() {
                String uuid = config.getUUID().toString();
                OperatingSystemMXBean osb = ManagementFactory.getOperatingSystemMXBean();
                String load = String.valueOf((int)(osb.getSystemLoadAverage() * 100.0 / (double)osb.getAvailableProcessors()));
                long totalRAM = Runtime.getRuntime().maxMemory();
                long usedRAM = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                DIR.ServiceDataMap.Builder dmap = DIR.ServiceDataMap.newBuilder();
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("load").setValue(load).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("proto_version").setValue(Integer.toString(20001)).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("totalRAM").setValue(Long.toString(totalRAM)).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("usedRAM").setValue(Long.toString(usedRAM)).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("geoCoordinates").setValue(config.getGeoCoordinates()).build());
                if (MRCRequestDispatcher.this.replicated) {
                    InetSocketAddress localReplAddr = (InetSocketAddress)MRCRequestDispatcher.this.volumeManager.getDBStatus().get("replication.control.address");
                    assert (localReplAddr != null);
                    dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("babudbReplAddr").setValue(localReplAddr.getAddress().getHostAddress() + ":" + localReplAddr.getPort()).build());
                }
                if (config.getHttpPort() != -1) {
                    try {
                        String address = "".equals(config.getHostName()) ? (config.getAddress() == null ? config.getUUID().getMappings()[0].resolvedAddr.getAddress().getHostAddress() : config.getAddress().getHostAddress()) : config.getHostName();
                        dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("status_page_url").setValue("http://" + address + ":" + config.getHttpPort()));
                    }
                    catch (UnknownUUIDException ex) {
                        Logging.logError(3, this, ex);
                    }
                }
                DIR.Service mrcReg = DIR.Service.newBuilder().setType(DIR.ServiceType.SERVICE_TYPE_MRC).setUuid(uuid).setData(dmap).setVersion(0L).setLastUpdatedS(0L).setName("MRC @ " + uuid).build();
                DIR.ServiceSet.Builder sregs = DIR.ServiceSet.newBuilder().addServices(mrcReg);
                Collection<StorageManager> storageManagers = MRCRequestDispatcher.this.volumeManager.getStorageManagers();
                if (storageManagers == null) {
                    Logging.logMessage(4, (Object)Logging.Category.misc, "cannot register volumes because volume manager not initialized yet", new Object[0]);
                } else {
                    for (StorageManager sMan : storageManagers) {
                        VolumeInfo vol = sMan.getVolumeInfo();
                        try {
                            DIR.Service dsVolumeInfo = MRCHelper.createDSVolumeInfo(vol, MRCRequestDispatcher.this.osdMonitor, sMan, uuid);
                            sregs.addServices(dsVolumeInfo);
                        }
                        catch (Exception exc) {
                            Logging.logMessage(4, Logging.Category.misc, this, "could not send heartbeat signal for volume '%s': %s", vol.getName(), exc.toString());
                        }
                    }
                }
                return sregs.build();
            }
        };
        if (config.getHttpPort() == -1) {
            this.statusServer = null;
        } else {
            this.statusServer = new StatusServer(DIR.ServiceType.SERVICE_TYPE_MRC, this, config.getHttpPort());
            this.statusServer.registerModule(new StatusPage());
            this.statusServer.registerModule(new PrintStackTrace());
            final MRCRequestDispatcher master = this;
            this.statusServer.registerModule(new BabuDBStatusPage(new BabuDBStatusPage.BabuDBStatusProvider(){

                @Override
                public Map<String, Object> getStatus() {
                    return master.getDBStatus();
                }
            }));
            if (config.getAdminPassword().length() > 0) {
                this.statusServer.addAuthorizedUser("admin", config.getAdminPassword());
            }
            this.statusServer.start();
        }
        this.heartbeatThread = new HeartbeatThread("MRC Heartbeat Thread", this.dirClient, config.getUUID(), gen, config, false);
        this.heartbeatThread.setLifeCycleListener(this);
        this.onCloseReplicationThread = new OnCloseReplicationThread(this);
        this.onCloseReplicationThread.setLifeCycleListener(this);
        if (this.replicated) {
            this.mrcMonitor = new MRCStatusManager(this);
            this.mrcMonitor.setLifeCycleListener(this);
        } else {
            this.mrcMonitor = null;
        }
    }

    public void asyncShutdown() {
        this.onCloseReplicationThread.shutdown();
        this.heartbeatThread.shutdown();
        this.serverStage.shutdown();
        this.clientStage.shutdown();
        this.osdMonitor.shutdown();
        this.procStage.shutdown();
        this.xLocSetCoordinator.shutdown();
        this.volumeManager.shutdown();
        if (this.statusServer != null) {
            this.statusServer.shutdown();
        }
        if (this.replicated) {
            this.mrcMonitor.shutdown();
        }
    }

    public void startup() {
        try {
            TimeSync.getInstance().init(TimeSync.ExtSyncSource.XTREEMFS_DIR, this.dirClient, null, this.config.getRemoteTimeSync(), this.config.getLocalClockRenew());
            this.clientStage.start();
            this.clientStage.waitForStartup();
            UUIDResolver.start(this.dirClient, 10000, 600000);
            UUIDResolver.addLocalMapping(this.config.getUUID(), this.config.getPort(), Schemes.getScheme(this.config.isUsingSSL(), this.config.isGRIDSSLmode()));
            UUIDResolver.addLocalMapping(this.config.getUUID(), this.config.getPort(), "pbrpcu");
            this.volumeManager.init();
            this.volumeManager.addVolumeChangeListener(this.osdMonitor);
            this.heartbeatThread.initialize();
            this.heartbeatThread.start();
            this.osdMonitor.start();
            this.osdMonitor.waitForStartup();
            if (this.replicated) {
                this.mrcMonitor.start();
                this.mrcMonitor.waitForStartup();
            }
            this.xLocSetCoordinator.start();
            this.xLocSetCoordinator.waitForStartup();
            this.procStage.start();
            this.procStage.waitForStartup();
            this.onCloseReplicationThread.start();
            this.onCloseReplicationThread.waitForStartup();
            this.serverStage.start();
            this.serverStage.waitForStartup();
            if (Logging.isInfo()) {
                Logging.logMessage(6, Logging.Category.lifecycle, this, "MRC operational, listening on port %d", this.config.getPort());
            }
        }
        catch (Exception ex) {
            Logging.logMessage(3, this, "STARTUP FAILED!", new Object[0]);
            Logging.logError(3, this, ex);
            System.exit(1);
        }
    }

    public void shutdown() throws Exception {
        for (MRCStatusListener listener : this.statusListener) {
            listener.shuttingDown();
        }
        this.onCloseReplicationThread.shutdown();
        this.onCloseReplicationThread.waitForShutdown();
        this.heartbeatThread.shutdown();
        this.heartbeatThread.waitForShutdown();
        this.serverStage.shutdown();
        this.serverStage.waitForShutdown();
        this.clientStage.shutdown();
        this.clientStage.waitForShutdown();
        this.osdMonitor.shutdown();
        this.osdMonitor.waitForShutdown();
        if (this.replicated) {
            this.mrcMonitor.shutdown();
            this.mrcMonitor.waitForShutdown();
        }
        this.procStage.shutdown();
        this.procStage.waitForShutdown();
        this.xLocSetCoordinator.shutdown();
        this.xLocSetCoordinator.waitForShutdown();
        this.volumeManager.shutdown();
        this.statusServer.shutdown();
    }

    public void requestFinished(MRCRequest request) {
        assert (request != null);
        RPCServerRequest rpcRequest = request.getRPCRequest();
        assert (rpcRequest != null);
        if (request.getError() != null) {
            ErrorRecord error = request.getError();
            String errorMessage = error.getErrorMessage() == null ? "" : error.getErrorMessage();
            switch (error.getErrorType()) {
                case INTERNAL_SERVER_ERROR: {
                    Logging.logMessage(3, this, "%s / request: %s", errorMessage, request.toString());
                    if (error.getThrowable() != null) {
                        Logging.logError(3, this, error.getThrowable());
                    }
                    rpcRequest.sendError(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_EIO, errorMessage, error.getStackTrace());
                    break;
                }
                case ERRNO: {
                    if (Logging.isDebug()) {
                        Logging.logUserError(7, Logging.Category.proc, this, error.getThrowable());
                    }
                    rpcRequest.sendError(RPC.ErrorType.ERRNO, error.getErrorCode(), errorMessage, "");
                    break;
                }
                case AUTH_FAILED: {
                    if (Logging.isDebug()) {
                        Logging.logUserError(7, Logging.Category.proc, this, error.getThrowable());
                    }
                    rpcRequest.sendError(RPC.ErrorType.AUTH_FAILED, error.getErrorCode(), errorMessage, "");
                    break;
                }
                case GARBAGE_ARGS: {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.proc, this, "invalid request arguments", new Object[0]);
                        Logging.logMessage(7, Logging.Category.proc, this, errorMessage, new Object[0]);
                    }
                    rpcRequest.sendError(RPC.ErrorType.GARBAGE_ARGS, RPC.POSIXErrno.POSIX_ERROR_EINVAL, errorMessage, error.getStackTrace());
                    break;
                }
                case INVALID_INTERFACE_ID: {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.stage, this, "invalid interface: %d", request.getRPCRequest().getHeader().getRequestHeader().getInterfaceId());
                        Logging.logMessage(7, Logging.Category.proc, this, errorMessage, new Object[0]);
                    }
                    rpcRequest.sendError(RPC.ErrorType.INVALID_INTERFACE_ID, RPC.POSIXErrno.POSIX_ERROR_EINVAL, errorMessage, error.getStackTrace());
                    break;
                }
                case INVALID_PROC_ID: {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.stage, this, "unknown operation: %d", request.getRPCRequest().getHeader().getRequestHeader().getProcId());
                    }
                    rpcRequest.sendError(RPC.ErrorType.INVALID_PROC_ID, RPC.POSIXErrno.POSIX_ERROR_EINVAL, errorMessage, error.getStackTrace());
                    break;
                }
                case REDIRECT: {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.stage, this, "redirect to: %s", errorMessage);
                    }
                    rpcRequest.sendRedirect(errorMessage);
                    break;
                }
                default: {
                    Logging.logMessage(3, this, "some unexpected exception occurred", new Object[0]);
                    Logging.logError(3, this, error.getThrowable());
                    rpcRequest.sendError(RPC.ErrorType.IO_ERROR, RPC.POSIXErrno.POSIX_ERROR_EIO, errorMessage, error.getStackTrace());
                    break;
                }
            }
        } else {
            assert (request.getResponse() != null);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "sending response for request %d", request.getRPCRequest().getHeader().getCallId());
                Logging.logMessage(7, Logging.Category.proc, this, "%s", request.getResponse().toString());
            }
            try {
                rpcRequest.sendResponse(request.getResponse(), null);
            }
            catch (IOException e) {
                Logging.logError(3, this, e);
            }
        }
    }

    public int getNumConnections() {
        return this.serverStage.getNumConnections();
    }

    public long getNumRequests() {
        return this.serverStage.getPendingRequests();
    }

    public Map<StatusPage.Vars, String> getStatusInformation() {
        HashMap<StatusPage.Vars, String> data = new HashMap<StatusPage.Vars, String>();
        data.put(StatusPage.Vars.AVAILPROCS, String.valueOf(Runtime.getRuntime().availableProcessors()));
        data.put(StatusPage.Vars.BPSTATS, BufferPool.getStatus());
        data.put(StatusPage.Vars.DEBUG, Integer.toString(this.config.getDebugLevel()));
        data.put(StatusPage.Vars.DIRURL, (this.config.isUsingSSL() ? (this.config.isGRIDSSLmode() ? "pbrpcg" : "pbrpcs") : "pbrpc") + "://" + this.config.getDirectoryService().getHostName() + ":" + this.config.getDirectoryService().getPort());
        data.put(StatusPage.Vars.GLOBALRESYNC, Long.toString(TimeSync.getTimeSyncInterval()));
        long globalTime = TimeSync.getGlobalTime();
        long localTime = TimeSync.getLocalSystemTime();
        data.put(StatusPage.Vars.GLOBALTIME, new Date(globalTime).toString() + " (" + globalTime + ")");
        data.put(StatusPage.Vars.LOCALTIME, new Date(localTime).toString() + " (" + localTime + ")");
        data.put(StatusPage.Vars.LOCALRESYNC, Long.toString(TimeSync.getLocalRenewInterval()));
        data.put(StatusPage.Vars.PORT, Integer.toString(this.config.getPort()));
        data.put(StatusPage.Vars.UUID, this.config.getUUID().toString());
        data.put(StatusPage.Vars.UUIDCACHE, UUIDResolver.getCache());
        data.put(StatusPage.Vars.PROTOVERSION, Integer.toString(20001));
        data.put(StatusPage.Vars.VERSION, "1.5.0-master");
        data.put(StatusPage.Vars.DBVERSION, this.volumeManager.getDBVersion());
        data.put(StatusPage.Vars.PINKYQ, Long.toString(this.serverStage.getPendingRequests()));
        data.put(StatusPage.Vars.NUMCON, Integer.toString(this.serverStage.getNumConnections()));
        long freeMem = Runtime.getRuntime().freeMemory();
        String span = "<span>";
        if (freeMem < 0x2000000L) {
            span = "<span class=\"levelWARN\">";
        } else if (freeMem < 0x200000L) {
            span = "<span class=\"levelERROR\">";
        }
        data.put(StatusPage.Vars.MEMSTAT, span + OutputUtils.formatBytes(freeMem) + " / " + OutputUtils.formatBytes(Runtime.getRuntime().maxMemory()) + " / " + OutputUtils.formatBytes(Runtime.getRuntime().totalMemory()) + "</span>");
        StringBuffer rqTableBuf = new StringBuffer();
        long totalRequests = 0L;
        for (Map.Entry<Integer, Integer> entry : this.procStage.get_opCountMap().entrySet()) {
            long count = entry.getValue().intValue();
            totalRequests += count;
            if (count == 0L) continue;
            try {
                String req = StatusPage.getOpName(entry.getKey());
                rqTableBuf.append("<tr><td align=\"left\">'");
                rqTableBuf.append(req);
                rqTableBuf.append("'</td><td>");
                rqTableBuf.append(count);
                rqTableBuf.append("</td></tr>");
            }
            catch (Exception e) {}
        }
        data.put(StatusPage.Vars.TOTALNUMRQ, totalRequests + "");
        data.put(StatusPage.Vars.RQSTATS, rqTableBuf.toString());
        try {
            Collection<StorageManager> sMans = this.volumeManager.getStorageManagers();
            if (sMans != null) {
                StringBuffer volTableBuf = new StringBuffer();
                ArrayList<VolumeInfo> volumes = new ArrayList<VolumeInfo>(sMans.size());
                for (StorageManager sMan : sMans) {
                    volumes.add(sMan.getVolumeInfo());
                }
                Collections.sort(volumes, new Comparator<VolumeInfo>(){

                    @Override
                    public int compare(VolumeInfo o1, VolumeInfo o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                boolean first = true;
                for (VolumeInfo v : volumes) {
                    DIR.ServiceSet osdList = this.osdMonitor.getUsableOSDs(v.getId()).build();
                    if (!first) {
                        volTableBuf.append("<tr><td colspan=\"2\"><hr style=\"height:1px\"/></td></tr>");
                    }
                    volTableBuf.append("<tr><td align=\"left\">");
                    volTableBuf.append(v.getName());
                    volTableBuf.append("</td><td><table border=\"0\" cellpadding=\"0\"><tr><td class=\"subtitle\">selectable OSDs</td><td align=\"right\">");
                    Iterator<DIR.Service> it = osdList.getServicesList().iterator();
                    while (it.hasNext()) {
                        DIR.Service osd = it.next();
                        ServiceUUID osdUUID = new ServiceUUID(osd.getUuid());
                        volTableBuf.append(osdUUID);
                        if (!it.hasNext()) continue;
                        volTableBuf.append(", ");
                    }
                    StripingPolicy defaultSP = this.volumeManager.getStorageManager(v.getId()).getDefaultStripingPolicy(1L);
                    GlobalTypes.AccessControlPolicyType policy = GlobalTypes.AccessControlPolicyType.valueOf(v.getAcPolicyId());
                    volTableBuf.append("</td></tr><tr><td class=\"subtitle\">striping policy</td><td>");
                    volTableBuf.append(Converter.stripingPolicyToString(defaultSP));
                    volTableBuf.append("</td></tr><tr><td class=\"subtitle\">access policy</td><td>");
                    volTableBuf.append(policy != null ? policy.name() : Short.valueOf(v.getAcPolicyId()));
                    volTableBuf.append("</td></tr><tr><td class=\"subtitle\">osd policy</td><td>");
                    volTableBuf.append(Converter.shortArrayToString(v.getOsdPolicy()));
                    volTableBuf.append("</td></tr><tr><td class=\"subtitle\">replica policy</td><td>");
                    volTableBuf.append(Converter.shortArrayToString(v.getReplicaPolicy()));
                    volTableBuf.append("</td></tr><tr><td class=\"subtitle\">#files</td><td>");
                    volTableBuf.append(v.getNumFiles());
                    volTableBuf.append("</td></tr><tr></tr><tr><td class=\"subtitle\">#directories</td><td>");
                    volTableBuf.append(v.getNumDirs());
                    volTableBuf.append("</td></tr><tr><td class=\"subtitle\">free disk space:</td><td>");
                    long quota = v.getVolumeQuota();
                    long freeSpaceOnOsds = this.osdMonitor.getFreeSpace(v.getId());
                    long quotaFreeSpace = quota - v.getVolumeSize();
                    if (quota != 0L && quotaFreeSpace < freeSpaceOnOsds) {
                        quotaFreeSpace = quotaFreeSpace < 0L ? 0L : quotaFreeSpace;
                        volTableBuf.append(OutputUtils.formatBytes(quotaFreeSpace));
                    } else {
                        volTableBuf.append(OutputUtils.formatBytes(freeSpaceOnOsds));
                    }
                    volTableBuf.append("</td></tr><tr><td class=\"subtitle\">occupied disk space:</td><td>");
                    volTableBuf.append(OutputUtils.formatBytes(v.getVolumeSize()));
                    volTableBuf.append("</td></tr></table></td></tr>");
                    first = false;
                }
                data.put(StatusPage.Vars.VOLUMES, volTableBuf.toString());
            } else {
                data.put(StatusPage.Vars.VOLUMES, "<tr><td align=\"left\">Volumes not yet initialized!</td></tr>");
            }
        }
        catch (Exception exc) {
            data.put(StatusPage.Vars.VOLUMES, "<tr><td align=\"left\">could not retrieve volume info due to an server internal error: " + exc + "</td></tr>");
        }
        return data;
    }

    public VolumeManager getVolumeManager() {
        return this.volumeManager;
    }

    public FileAccessManager getFileAccessManager() {
        return this.fileAccessManager;
    }

    public AuthenticationProvider getAuthProvider() {
        return this.authProvider;
    }

    public OSDStatusManager getOSDStatusManager() {
        return this.osdMonitor;
    }

    public OnCloseReplicationThread getOnCloseReplicationThread() {
        return this.onCloseReplicationThread;
    }

    public MRCPolicyContainer getPolicyContainer() {
        return this.policyContainer;
    }

    public DIRClient getDirClient() {
        return this.dirClient;
    }

    public OSDServiceClient getOSDClient() {
        return this.osdClient;
    }

    public MRCConfig getConfig() {
        return this.config;
    }

    @Override
    public void startupPerformed() {
    }

    @Override
    public void shutdownPerformed() {
    }

    @Override
    public void crashPerformed(Throwable cause) {
        String report = CrashReporter.createCrashReport("MRC", "1.5.0-master", cause);
        System.out.println(report);
        CrashReporter.reportXtreemFSCrash(report);
        try {
            this.shutdown();
        }
        catch (Exception e) {
            Logging.logError(3, this, e);
            System.exit(1);
        }
    }

    @Override
    public void receiveRecord(RPCServerRequest rq) {
        RPC.RPCHeader hdr = rq.getHeader();
        if (hdr.getMessageType() != RPC.MessageType.RPC_REQUEST) {
            rq.sendError(RPC.ErrorType.GARBAGE_ARGS, RPC.POSIXErrno.POSIX_ERROR_EIO, "expected RPC request message type but got " + hdr.getMessageType());
            return;
        }
        RPC.RPCHeader.RequestHeader rqHdr = hdr.getRequestHeader();
        if (rqHdr.getInterfaceId() != 20001) {
            rq.sendError(RPC.ErrorType.INVALID_INTERFACE_ID, RPC.POSIXErrno.POSIX_ERROR_EIO, "Invalid interface id. This is a MRC service. You probably wanted to contact another service. Check the used address and port.");
            return;
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.stage, this, "enqueueing request: %s", rq.toString());
        }
        this.procStage.enqueueOperation(new MRCRequest(rq), 1, null);
    }

    @Override
    public void failed(Throwable error, Object context) {
        MRCRequest request = (MRCRequest)context;
        assert (request != null);
        RPCServerRequest rpcRequest = request.getRPCRequest();
        assert (rpcRequest != null);
        if (request.getError() == null) {
            request.setError(RPC.ErrorType.INTERNAL_SERVER_ERROR, error.getMessage());
        }
        this.requestFinished(request);
    }

    @Override
    public void finished(Object result, Object context) {
        this.requestFinished((MRCRequest)context);
    }

    public void addStatusListener(MRCStatusListener listener) {
        this.statusListener.add(listener);
    }

    public void removeStatusListener(MRCStatusListener listener) {
        this.statusListener.remove(listener);
    }

    public void notifyConfigurationChange() {
        for (MRCStatusListener listener : this.statusListener) {
            listener.MRCConfigChanged(this.config);
        }
    }

    public void notifyVolumeCreated() {
        for (MRCStatusListener listener : this.statusListener) {
            listener.volumeCreated();
        }
    }

    public void notifyVolumeDeleted() {
        for (MRCStatusListener listener : this.statusListener) {
            listener.volumeDeleted();
        }
    }

    public long getLastHeartbeat() {
        return this.heartbeatThread.getLastHeartbeat();
    }

    public Map<String, Object> getDBStatus() {
        return this.volumeManager == null ? null : this.volumeManager.getDBStatus();
    }

    public String getReplMasterUUID() throws MRCException {
        if (this.replicated) {
            String uuid;
            InetSocketAddress addr = (InetSocketAddress)this.volumeManager.getDBStatus().get("replication.control.master");
            String string = uuid = addr == null ? null : this.mrcMonitor.getUUIDForReplHost(addr);
            if (uuid == null) {
                try {
                    this.mrcMonitor.waitForNextSync(true);
                    addr = (InetSocketAddress)this.volumeManager.getDBStatus().get("replication.control.master");
                    uuid = addr == null ? null : this.mrcMonitor.getUUIDForReplHost(addr);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (uuid == null) {
                    Logging.logMessage(6, this, "unable to detect replication master; BabuDB addr=%s, UUID=%s", addr.toString(), uuid);
                    throw new MRCException("could not detect replication master");
                }
            }
            return uuid;
        }
        return null;
    }

    public void pauseHeartbeatThread() throws InterruptedException {
        this.heartbeatThread.pauseOperation();
    }

    public void resumeHeartbeatThread() {
        this.heartbeatThread.resumeOperation();
    }

    public XLocSetCoordinator getXLocSetCoordinator() {
        return this.xLocSetCoordinator;
    }

    public ProcessingStage getProcStage() {
        return this.procStage;
    }

    public int hashCode() {
        StringBuilder hashString = new StringBuilder();
        hashString.append(super.hashCode());
        hashString.append(this.config.getUUID());
        hashString.append(this.initTimeMS);
        return hashString.toString().hashCode();
    }
}

