/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class MRCStatusManager
extends LifeCycleThread {
    private int checkIntervalMillis = 5000;
    private DIR.ServiceSet.Builder knownMRCs;
    private Map<InetSocketAddress, String> mrcAddrMap;
    private Object syncLock = new Object();
    private boolean quit = false;
    private MRCRequestDispatcher master;

    public MRCStatusManager(MRCRequestDispatcher master) throws IOException {
        super("MRCStatusManager");
        this.master = master;
        this.knownMRCs = DIR.ServiceSet.newBuilder();
        this.mrcAddrMap = new HashMap<InetSocketAddress, String>();
        int interval = master.getConfig().getOsdCheckInterval();
        this.checkIntervalMillis = 1000 * interval;
    }

    @Override
    public synchronized void shutdown() {
        this.quit = true;
        this.interrupt();
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.knownMRCs = this.master.getDirClient().xtreemfs_service_get_by_type(null, RPCAuthentication.authNone, RPCAuthentication.userService, DIR.ServiceType.SERVICE_TYPE_MRC).toBuilder();
        }
        catch (Throwable exc) {
            this.notifyCrashed(exc);
        }
        this.notifyStarted();
        if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.lifecycle, this, "MRC status manager operational, using DIR %s", this.master.getConfig().getDirectoryService().toString());
        }
        while (!this.quit) {
            block15: {
                MRCStatusManager exc = this;
                synchronized (exc) {
                    try {
                        this.wait(this.knownMRCs == null || this.knownMRCs.getServicesCount() == 0 ? (long)(this.checkIntervalMillis / 2) : (long)this.checkIntervalMillis);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
                Logging.logMessage(7, Logging.Category.misc, this, "sending request for MRC list to DIR...", new Object[0]);
                try {
                    this.knownMRCs = this.master.getDirClient().xtreemfs_service_get_by_type(null, RPCAuthentication.authNone, RPCAuthentication.userService, DIR.ServiceType.SERVICE_TYPE_MRC).toBuilder();
                    Logging.logMessage(7, Logging.Category.misc, this, "... received MRC list from DIR", new Object[0]);
                    this.evaluateResponse(this.knownMRCs);
                }
                catch (InterruptedException ex) {
                    break;
                }
                catch (Exception exc2) {
                    if (this.quit) break block15;
                    Logging.logMessage(3, Logging.Category.misc, this, OutputUtils.stackTraceToString(exc2), new Object[0]);
                }
            }
            Object object = this.syncLock;
            synchronized (object) {
                this.syncLock.notifyAll();
            }
        }
        this.notifyStopped();
    }

    public synchronized void evaluateResponse(DIR.ServiceSet.Builder knownMRCs) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "response...", new Object[0]);
        }
        assert (knownMRCs != null);
        assert (knownMRCs.getServicesCount() != 0);
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "registered MRCs", new Object[0]);
            for (DIR.Service mrc : knownMRCs.getServicesList()) {
                Logging.logMessage(7, Logging.Category.misc, this, "%s", mrc.getUuid());
            }
        }
        this.knownMRCs = knownMRCs;
        this.mrcAddrMap.clear();
        for (DIR.Service mrc : knownMRCs.getServicesList()) {
            int index;
            String endpoint = KeyValuePairs.getValue(mrc.getData().getDataList(), "babudbReplAddr");
            if (endpoint == null || (index = endpoint.indexOf(58)) == -1) continue;
            this.mrcAddrMap.put(new InetSocketAddress(endpoint.substring(0, index), Integer.parseInt(endpoint.substring(index + 1))), mrc.getUuid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNextSync(boolean immediately) throws InterruptedException {
        Object object = this;
        synchronized (object) {
            if (immediately) {
                this.notify();
            }
        }
        object = this.syncLock;
        synchronized (object) {
            this.syncLock.wait();
        }
    }

    public synchronized String getUUIDForReplHost(InetSocketAddress host) {
        return this.mrcAddrMap.get(host);
    }
}

