/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.xtreemfs.common.statusserver.StatusServerHelper;
import org.xtreemfs.common.statusserver.StatusServerModule;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceConstants;

public class StatusPage
extends StatusServerModule {
    private final String statusPageTemplate;
    private MRCRequestDispatcher master;
    private static final Map<Integer, String> opNames = new HashMap<Integer, String>();

    public StatusPage() {
        StringBuffer sb = StatusServerHelper.readTemplate("org/xtreemfs/mrc/templates/status.html");
        this.statusPageTemplate = sb == null ? "<h1>Template was not found, unable to show status page!</h1>" : sb.toString();
    }

    @Override
    public void initialize(DIR.ServiceType service, Object serviceRequestDispatcher) {
        assert (service == DIR.ServiceType.SERVICE_TYPE_MRC);
        this.master = (MRCRequestDispatcher)serviceRequestDispatcher;
    }

    @Override
    public String getDisplayName() {
        return "MRC Status Page";
    }

    @Override
    public String getUriPath() {
        return "/";
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        Map<Vars, String> vars = this.master.getStatusInformation();
        String tmp = this.statusPageTemplate;
        for (Vars key : vars.keySet()) {
            tmp = tmp.replace(key.toString(), vars.get((Object)key));
        }
        this.sendResponse(httpExchange, tmp);
        httpExchange.close();
    }

    @Override
    public boolean isAvailableForService(DIR.ServiceType service) {
        return service == DIR.ServiceType.SERVICE_TYPE_MRC;
    }

    @Override
    public void shutdown() {
    }

    public static String getOpName(int opId) {
        String name = opNames.get(opId);
        return name == null ? null : name;
    }

    static {
        for (Field field : MRCServiceConstants.class.getDeclaredFields()) {
            if (!field.getName().startsWith("PROC_ID")) continue;
            try {
                opNames.put(field.getInt(null), field.getName().substring("PROC_ID_".length()).toLowerCase());
            }
            catch (IllegalArgumentException e) {
                Logging.logError(3, null, e);
            }
            catch (IllegalAccessException e) {
                Logging.logError(3, null, e);
            }
        }
    }

    public static enum Vars {
        LASTRQDATE("<!-- $LASTRQDATE -->"),
        TOTALNUMRQ("<!-- $TOTALNUMRQ -->"),
        RQSTATS("<!-- $RQSTATS -->"),
        VOLUMES("<!-- $VOLUMES -->"),
        UUID("<!-- $UUID -->"),
        AVAILPROCS("<!-- $AVAILPROCS -->"),
        BPSTATS("<!-- $BPSTATS -->"),
        PORT("<!-- $PORT -->"),
        DIRURL("<!-- $DIRURL -->"),
        DEBUG("<!-- $DEBUG -->"),
        NUMCON("<!-- $NUMCON -->"),
        PINKYQ("<!-- $PINKYQ -->"),
        PROCQ("<!-- $PROCQ -->"),
        GLOBALTIME("<!-- $GLOBALTIME -->"),
        GLOBALRESYNC("<!-- $GLOBALRESYNC -->"),
        LOCALTIME("<!-- $LOCALTIME -->"),
        LOCALRESYNC("<!-- $LOCALRESYNC -->"),
        MEMSTAT("<!-- $MEMSTAT -->"),
        UUIDCACHE("<!-- $UUIDCACHE -->"),
        DISKFREE("<!-- $DISKFREE -->"),
        PROTOVERSION("<!-- $PROTOVERSION -->"),
        VERSION("<!-- $VERSION -->"),
        DBVERSION("<!-- $DBVERSION -->");

        private String template;

        private Vars(String template) {
            this.template = template;
        }

        public String toString() {
            return this.template;
        }
    }
}

