/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.ac;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCException;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.ac.FileAccessPolicy;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.metadata.ACLEntry;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class POSIXFileAccessPolicy
implements FileAccessPolicy {
    public static final short POLICY_ID = (short)GlobalTypes.AccessControlPolicyType.ACCESS_CONTROL_POLICY_POSIX.getNumber();
    protected static final String OWNER = "u:";
    protected static final String OWNER_GROUP = "g:";
    protected static final String OTHER = "o:";
    protected static final String MASK = "m:";
    protected static final String NAMED_USER_PREFIX = "u:";
    protected static final String NAMED_GROUP_PREFIX = "g:";
    protected static final String STICKY_BIT = "sticky";
    protected static final String AM_WRITE = "w";
    protected static final String AM_READ = "r";
    protected static final String AM_READ_WRITE = "rw";
    protected static final String AM_EXECUTE = "x";
    protected static final String AM_DELETE = "d";
    protected static final String AM_MV_RM_IN_DIR = "m";
    protected static final int POSIX_OTHER_EXEC = 1;
    protected static final int POSIX_OTHER_WRITE = 2;
    protected static final int POSIX_OTHER_READ = 4;
    protected static final int POSIX_GROUP_EXEC = 8;
    protected static final int POSIX_GROUP_WRITE = 16;
    protected static final int POSIX_GROUP_READ = 32;
    protected static final int POSIX_OWNER_EXEC = 64;
    protected static final int POSIX_OWNER_WRITE = 128;
    protected static final int POSIX_OWNER_READ = 256;
    protected static final int POSIX_STICKY = 512;
    protected static final int POSIX_SGID = 1024;
    protected static final int POSIX_SUID = 2048;
    protected static final short PERM_READ = 1;
    protected static final short PERM_WRITE = 2;
    protected static final short PERM_EXECUTE = 4;
    protected static final short PERM_APPEND = 8;
    protected static final short PERM_GFS_APPEND = 16;
    protected static final short PERM_CREATE = 32;
    protected static final short PERM_TRUNCATE = 64;
    protected static final short PERM_STRICT_READ = 128;
    protected static final short PERM_DELETE = 256;
    protected static final short PERM_SUID_SGID = 16384;
    protected static final short READ_MASK = 129;
    protected static final short WRITE_MASK = 378;
    protected static final short EXEC_MASK = 4;
    protected static final short READ_ONLY_MASK = 365;

    @Override
    public String translateAccessFlags(int accessMode) {
        if ((accessMode &= FileAccessManager.O_RDWR | FileAccessManager.O_WRONLY | FileAccessManager.O_APPEND | FileAccessManager.O_TRUNC | 0x100000 | 0x200000 | 0x400000) == FileAccessManager.O_RDONLY) {
            return AM_READ;
        }
        if ((accessMode & FileAccessManager.O_WRONLY) != 0 || (accessMode & FileAccessManager.O_APPEND) != 0 || (accessMode & FileAccessManager.O_TRUNC) != 0) {
            return AM_WRITE;
        }
        if ((accessMode & FileAccessManager.O_RDWR) != 0) {
            return AM_READ_WRITE;
        }
        if ((accessMode & 0x100000) != 0) {
            return AM_EXECUTE;
        }
        if ((accessMode & 0x200000) != 0) {
            return AM_DELETE;
        }
        if ((accessMode & 0x400000) != 0) {
            return AM_MV_RM_IN_DIR;
        }
        assert (false) : "unknown access mode: " + accessMode;
        return null;
    }

    @Override
    public String translatePermissions(int permissions) {
        StringBuilder sb = new StringBuilder();
        sb.append((permissions & 1) > 0 ? AM_READ : "-");
        sb.append((permissions & 2) > 0 ? AM_WRITE : "-");
        sb.append((permissions & 4) > 0 ? AM_EXECUTE : "-");
        return sb.toString();
    }

    @Override
    public void checkPermission(StorageManager sMan, FileMetadata file, long parentId, String userId, List<String> groupIds, String accessMode) throws UserException, MRCException {
        assert (file != null);
        DatabaseResultSet<ACLEntry> aclSet = null;
        try {
            aclSet = sMan.getACL(file.getId());
            if (aclSet.hasNext()) {
                ACLEntry entry = POSIXFileAccessPolicy.getRelevantACLEntry(sMan, file, parentId, userId, groupIds, accessMode);
                assert (entry != null);
                if (OTHER.equals(entry.getEntity()) || "u:".equals(entry.getEntity())) {
                    if (POSIXFileAccessPolicy.checkIfAllowed(sMan, accessMode, entry.getRights(), file, parentId, userId)) {
                        return;
                    }
                    POSIXFileAccessPolicy.accessDenied(sMan.getVolumeInfo().getId(), file, accessMode, userId);
                }
                ACLEntry maskEntry = sMan.getACLEntry(file.getId(), MASK);
                if (POSIXFileAccessPolicy.checkIfAllowed(sMan, accessMode, entry.getRights(), file, parentId, userId) && (maskEntry == null || POSIXFileAccessPolicy.checkIfAllowed(sMan, accessMode, maskEntry.getRights(), file, parentId, userId))) {
                    return;
                }
                POSIXFileAccessPolicy.accessDenied(sMan.getVolumeInfo().getId(), file, accessMode, userId);
            }
        }
        catch (UserException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MRCException(exc);
        }
        finally {
            if (aclSet != null) {
                aclSet.destroy();
            }
        }
    }

    @Override
    public void checkSearchPermission(StorageManager sMan, PathResolver res, String userId, List<String> groupIds) throws UserException, MRCException {
        try {
            FileMetadata[] rp = res.getResolvedPath();
            for (int i = 0; i < rp.length - 1; ++i) {
                this.checkPermission(sMan, rp[i], i == 0 ? 0L : rp[i - 1].getId(), userId, groupIds, AM_EXECUTE);
            }
        }
        catch (UserException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MRCException(exc);
        }
    }

    @Override
    public void checkPrivilegedPermissions(StorageManager sMan, FileMetadata file, String userId, List<String> groupIds) throws UserException, MRCException {
        try {
            if (!file.getOwnerId().equals(userId)) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "no privileged permissions granted");
            }
        }
        catch (UserException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MRCException(exc);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateACLEntries(StorageManager sMan, FileMetadata file, long parentId, Map<String, Object> entries, AtomicDBUpdate update) throws MRCException, UserException {
        DatabaseResultSet<ACLEntry> acl = null;
        try {
            void var10_16;
            Integer n;
            Map<Object, Object> aclMap = null;
            acl = sMan.getACL(file.getId());
            if (!acl.hasNext()) {
                aclMap = POSIXFileAccessPolicy.convertToACL(file.getPerms());
            } else {
                aclMap = new HashMap();
                while (acl.hasNext()) {
                    ACLEntry next = (ACLEntry)acl.next();
                    aclMap.put(next.getEntity(), next.getRights());
                }
            }
            for (Map.Entry<String, Object> entry : entries.entrySet()) {
                String entity = entry.getKey();
                String rwx = (String)entry.getValue();
                if (rwx != null) {
                    int rights = 0;
                    if (rwx.length() == 1 && rwx.charAt(0) >= '0' && rwx.charAt(0) <= '7') {
                        rights = Integer.parseInt(rwx, 8);
                        int tmp = (rights >> 2 ^ rights) & 1;
                        rights ^= tmp << 2 | tmp << 0;
                    } else {
                        if (rwx.indexOf(114) != -1) {
                            rights |= 1;
                        }
                        if (rwx.indexOf(119) != -1) {
                            rights |= 2;
                        }
                        if (rwx.indexOf(120) != -1) {
                            rights |= 4;
                        }
                    }
                    aclMap.put(entity, rights);
                    continue;
                }
                aclMap.put(entity, null);
            }
            for (Map.Entry<Object, Object> entry : aclMap.entrySet()) {
                Number rights = (Number)entry.getValue();
                sMan.setACLEntry(file.getId(), (String)entry.getKey(), rights == null ? null : Short.valueOf(rights.shortValue()), update);
            }
            int owner = ((Number)aclMap.get("u:")).intValue();
            Integer n2 = n = aclMap.get(MASK) != null ? Integer.valueOf(((Number)aclMap.get(MASK)).intValue()) : null;
            if (n == null) {
                Integer n3 = ((Number)aclMap.get("g:")).intValue();
            }
            int other = ((Number)aclMap.get(OTHER)).intValue();
            int posixRights = ((owner & 0x4000) > 0 ? 2048 : 0) | ((var10_16.intValue() & 0x4000) > 0 ? 1024 : 0) | file.getPerms() & 0x200 | ((owner & 1) > 0 ? 256 : 0) | ((owner & 2) > 0 ? 128 : 0) | ((owner & 4) > 0 ? 64 : 0) | ((var10_16.intValue() & 1) > 0 ? 32 : 0) | ((var10_16.intValue() & 2) > 0 ? 16 : 0) | ((var10_16.intValue() & 4) > 0 ? 8 : 0) | ((other & 1) > 0 ? 4 : 0) | ((other & 2) > 0 ? 2 : 0) | ((other & 4) > 0 ? 1 : 0);
            file.setPerms(posixRights);
            sMan.setMetadata(file, (byte)1, update);
        }
        catch (Exception exc) {
            throw new MRCException(exc);
        }
        finally {
            if (acl != null) {
                acl.destroy();
            }
        }
    }

    @Override
    public Map<String, Object> getACLEntries(StorageManager sMan, FileMetadata file) throws MRCException {
        try {
            DatabaseResultSet<ACLEntry> acl = sMan.getACL(file.getId());
            Map<String, Object> aclMap = Converter.aclToMap(acl, this);
            acl.destroy();
            return aclMap;
        }
        catch (Exception exc) {
            throw new MRCException(exc);
        }
    }

    @Override
    public void removeACLEntries(StorageManager sMan, FileMetadata file, long parentId, List<Object> entities, AtomicDBUpdate update) throws MRCException, UserException {
        HashMap<String, Object> entries = new HashMap<String, Object>();
        for (Object entity : entities) {
            entries.put((String)entity, null);
        }
        this.updateACLEntries(sMan, file, parentId, entries, update);
    }

    @Override
    public void setPosixAccessRights(StorageManager sMan, FileMetadata file, long parentId, String userId, List<String> groupIds, int posixAccessRights, boolean superUser, AtomicDBUpdate update) throws MRCException, UserException {
        DatabaseResultSet<ACLEntry> aclSet = null;
        try {
            if (!((posixAccessRights & 0x400) <= 0 || superUser || file.isDirectory() || groupIds.contains(file.getOwningGroupId()))) {
                posixAccessRights ^= 0x400;
            }
            file.setPerms(posixAccessRights);
            sMan.setMetadata(file, (byte)1, update);
            aclSet = sMan.getACL(file.getId());
            if (!aclSet.hasNext()) {
                return;
            }
            short owr = (posixAccessRights & 0x40) > 0 ? (short)4 : 0;
            owr = (short)(owr | ((posixAccessRights & 0x80) > 0 ? 378 : 0));
            owr = (short)(owr | ((posixAccessRights & 0x100) > 0 ? 129 : 0));
            owr = (short)(owr | ((posixAccessRights & 0x800) > 0 ? 16384 : 0));
            short grr = (posixAccessRights & 8) > 0 ? (short)4 : 0;
            grr = (short)(grr | ((posixAccessRights & 0x10) > 0 ? 378 : 0));
            grr = (short)(grr | ((posixAccessRights & 0x20) > 0 ? 129 : 0));
            grr = (short)(grr | ((posixAccessRights & 0x400) > 0 ? 16384 : 0));
            short otr = (posixAccessRights & 1) > 0 ? (short)4 : 0;
            otr = (short)(otr | ((posixAccessRights & 2) > 0 ? 378 : 0));
            otr = (short)(otr | ((posixAccessRights & 4) > 0 ? 129 : 0));
            sMan.setACLEntry(file.getId(), "u:", owr, update);
            sMan.setACLEntry(file.getId(), "g:", grr, update);
            sMan.setACLEntry(file.getId(), MASK, grr, update);
            sMan.setACLEntry(file.getId(), OTHER, otr, update);
        }
        catch (Exception exc) {
            throw new MRCException(exc);
        }
        finally {
            if (aclSet != null) {
                aclSet.destroy();
            }
        }
    }

    @Override
    public int getPosixAccessRights(StorageManager sMan, FileMetadata file, String userId, List<String> groupIds) throws MRCException {
        return !file.isDirectory() && file.isReadOnly() ? file.getPerms() & 0x16D : file.getPerms();
    }

    @Override
    public ACLEntry[] getDefaultRootACL() {
        return null;
    }

    private static boolean checkIfAllowed(StorageManager sMan, String accessMode, short aclRights, FileMetadata file, long parentId, String userId) throws DatabaseException {
        if (accessMode.length() == 1) {
            switch (accessMode.charAt(0)) {
                case 'r': {
                    return (aclRights & 1) != 0;
                }
                case 'w': {
                    return (aclRights & 2) != 0;
                }
                case 'x': {
                    return (aclRights & 4) != 0;
                }
                case 'a': {
                    return (aclRights & 8) != 0;
                }
                case 'c': {
                    return (aclRights & 0x20) != 0;
                }
                case 't': {
                    return (aclRights & 0x40) != 0;
                }
                case 'd': {
                    return (aclRights & 0x100) != 0;
                }
                case 'm': {
                    assert (parentId != 0L);
                    FileMetadata parent = sMan.getMetadata(parentId);
                    assert (parent != null) : "cannot resolve metadata for file ID " + parentId;
                    if ((parent.getPerms() & 0x200) != 0) {
                        return parent.getOwnerId().equals(userId) || file.getOwnerId().equals(userId);
                    }
                    return true;
                }
            }
        } else if (accessMode.length() == 2) {
            if (accessMode.equals(AM_READ_WRITE) && (aclRights & 1) != 0 & (aclRights & 2) != 0) {
                return true;
            }
            if (accessMode.equals("ga") && (aclRights & 0x10) != 0) {
                return true;
            }
            if (accessMode.equals("sr") && (aclRights & 0x80) != 0) {
                return true;
            }
        }
        return false;
    }

    private static short toRelativeACLRights(int posixRights, FileMetadata file, long parentId, String userId, List<String> groupIDs) {
        if (userId.equals(file.getOwnerId())) {
            short tmp = 0;
            if ((posixRights & 0x40) > 0) {
                tmp = (short)(tmp | 4);
            }
            if ((posixRights & 0x80) > 0) {
                tmp = (short)(tmp | 0x17A);
            }
            if ((posixRights & 0x100) > 0) {
                tmp = (short)(tmp | 0x81);
            }
            return tmp;
        }
        if (groupIDs.contains(file.getOwningGroupId())) {
            short tmp = 0;
            if ((posixRights & 8) > 0) {
                tmp = (short)(tmp | 4);
            }
            if ((posixRights & 0x10) > 0) {
                tmp = (short)(tmp | 0x17A);
            }
            if ((posixRights & 0x20) > 0) {
                tmp = (short)(tmp | 0x81);
            }
            return tmp;
        }
        short tmp = 0;
        if ((posixRights & 1) > 0) {
            tmp = (short)(tmp | 4);
        }
        if ((posixRights & 2) > 0) {
            tmp = (short)(tmp | 0x17A);
        }
        if ((posixRights & 4) > 0) {
            tmp = (short)(tmp | 0x81);
        }
        return tmp;
    }

    private static ACLEntry getRelevantACLEntry(StorageManager sMan, FileMetadata file, long parentId, String userId, List<String> groupIds, String accessMode) throws UserException, DatabaseException {
        if (file.getOwnerId().equals(userId)) {
            ACLEntry entry = sMan.getACLEntry(file.getId(), "u:");
            assert (entry != null);
            return entry;
        }
        ACLEntry entry = sMan.getACLEntry(file.getId(), "u:" + userId);
        if (entry != null) {
            return entry;
        }
        boolean groupFound = false;
        for (String groupId : groupIds) {
            if (!groupId.equals(file.getOwningGroupId())) continue;
            entry = sMan.getACLEntry(file.getId(), "g:");
            if (POSIXFileAccessPolicy.checkIfAllowed(sMan, accessMode, entry.getRights(), file, parentId, userId)) {
                return entry;
            }
            groupFound = true;
        }
        for (String groupId : groupIds) {
            entry = sMan.getACLEntry(file.getId(), "g:" + groupId);
            if (entry == null) continue;
            if (POSIXFileAccessPolicy.checkIfAllowed(sMan, accessMode, entry.getRights(), file, parentId, userId)) {
                return entry;
            }
            groupFound = true;
        }
        if (groupFound) {
            POSIXFileAccessPolicy.accessDenied(sMan.getVolumeInfo().getId(), file, accessMode, userId);
        }
        entry = sMan.getACLEntry(file.getId(), OTHER);
        assert (entry != null);
        return entry;
    }

    protected static Map<String, Object> convertToACL(long mode) throws MRCException {
        try {
            long stickyBit;
            HashMap<String, Object> aclMap = new HashMap<String, Object>();
            long l = stickyBit = (mode & 0x200L) > 0L ? 1L : 0L;
            if (stickyBit != 0L) {
                aclMap.put(STICKY_BIT, stickyBit);
            }
            long owr = (mode & 0x40L) > 0L ? 4L : 0L;
            owr |= (mode & 0x80L) > 0L ? 378L : 0L;
            owr |= (mode & 0x100L) > 0L ? 129L : 0L;
            aclMap.put("u:", owr |= (mode & 0x800L) > 0L ? 16384L : 0L);
            long grr = (mode & 8L) > 0L ? 4L : 0L;
            grr |= (mode & 0x10L) > 0L ? 378L : 0L;
            grr |= (mode & 0x20L) > 0L ? 129L : 0L;
            aclMap.put("g:", grr |= (mode & 0x400L) > 0L ? 16384L : 0L);
            long otr = (mode & 1L) > 0L ? 4L : 0L;
            otr |= (mode & 2L) > 0L ? 378L : 0L;
            aclMap.put(OTHER, otr |= (mode & 4L) > 0L ? 129L : 0L);
            return aclMap;
        }
        catch (Exception exc) {
            throw new MRCException(exc);
        }
    }

    private static void accessDenied(String volumeId, FileMetadata file, String accessMode, String userId) throws UserException {
        throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EACCES, "access denied, volumeId = " + volumeId + ", file = " + file.getId() + " (" + file.getFileName() + "), accessMode = \"" + accessMode + "\", requestor's uid = \"" + userId + "\", owner = \"" + file.getOwnerId() + "\"");
    }
}

