/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.database.babudb;

import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseInsertGroup;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;

public class AtomicBabuDBUpdate
implements AtomicDBUpdate {
    private DatabaseInsertGroup ig;
    private Database database;
    private DatabaseRequestListener<Object> listener;
    private Object context;

    public AtomicBabuDBUpdate(Database database, DatabaseRequestListener<Object> listener, Object context) throws BabuDBException {
        this.ig = database.createInsertGroup();
        this.database = database;
        this.listener = listener;
        this.context = context;
    }

    @Override
    public void addUpdate(Object ... update) {
        this.ig.addInsert(((Integer)update[0]).intValue(), (byte[])update[1], (byte[])update[2]);
    }

    @Override
    public void execute() throws DatabaseException {
        try {
            if (this.listener != null) {
                this.database.insert(this.ig, this.context).registerListener(this.listener);
            } else {
                this.database.insert(this.ig, this.context).get();
            }
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    public String toString() {
        return this.ig.toString();
    }
}

