/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.database.babudb;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.xtreemfs.babudb.api.SnapshotManager;
import org.xtreemfs.babudb.api.database.DatabaseRO;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DBAccessResultListener;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeChangeListener;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.babudb.AtomicBabuDBSnapshotUpdate;
import org.xtreemfs.mrc.database.babudb.BabuDBRequestListenerWrapper;
import org.xtreemfs.mrc.database.babudb.BabuDBSnapshotVolumeInfo;
import org.xtreemfs.mrc.database.babudb.BabuDBStorageHelper;
import org.xtreemfs.mrc.metadata.ACLEntry;
import org.xtreemfs.mrc.metadata.BufferBackedACLEntry;
import org.xtreemfs.mrc.metadata.BufferBackedFileMetadata;
import org.xtreemfs.mrc.metadata.BufferBackedXAttr;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.ReplicationPolicy;
import org.xtreemfs.mrc.metadata.StripingPolicy;
import org.xtreemfs.mrc.metadata.XAttr;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.DBAdminHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class BabuDBSnapshotStorageManager
implements StorageManager {
    public static final int FILE_INDEX = 0;
    public static final int XATTRS_INDEX = 1;
    public static final int ACL_INDEX = 2;
    public static final int FILE_ID_INDEX = 3;
    public static final int VOLUME_INDEX = 4;
    public static final byte[] LAST_ID_KEY = new byte[]{105};
    public static final byte[] VOL_SIZE_KEY = new byte[]{115};
    public static final byte[] NUM_FILES_KEY = new byte[]{102};
    public static final byte[] NUM_DIRS_KEY = new byte[]{100};
    private static final String DEFAULT_SP_ATTR_NAME = "sp";
    private static final String DEFAULT_RP_ATTR_NAME = "rp";
    private static final String LINK_TARGET_ATTR_NAME = "lt";
    protected static final String OSD_POL_ATTR_NAME = "osdPol";
    protected static final String REPL_POL_ATTR_NAME = "replPol";
    protected static final String AC_POL_ATTR_NAME = "acPol";
    protected static final String AUTO_REPL_FACTOR_ATTR_NAME = "replFactor";
    protected static final String AUTO_REPL_FULL_ATTR_NAME = "replFull";
    protected static final String VOL_ID_ATTR_NAME = "volId";
    protected static final String VOL_QUOTA = "quota";
    protected static final int[] ALL_INDICES = new int[]{0, 1, 2, 3, 4};
    private final DatabaseRO database;
    private final BabuDBSnapshotVolumeInfo volume;
    private final String volumeName;
    private final String rootDirName;
    private final long rootParentId;

    public BabuDBSnapshotStorageManager(SnapshotManager sMan, String volumeName, String volumeId, String snapName, long timestamp, long rootParentId) throws DatabaseException {
        this.volumeName = volumeName;
        try {
            this.database = sMan.getSnapshotDB(volumeId, snapName);
        }
        catch (BabuDBException e) {
            throw new DatabaseException("could not retrieve database for snapshot '" + snapName + "'", e);
        }
        try {
            this.rootParentId = rootParentId;
            this.rootDirName = BabuDBStorageHelper.getRootDirName(this.database, rootParentId);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
        if (this.rootParentId == -1L) {
            throw new DatabaseException("no root directory found", DatabaseException.ExceptionType.INTERNAL_DB_ERROR);
        }
        this.volume = new BabuDBSnapshotVolumeInfo(timestamp);
        this.volume.init(this);
    }

    @Override
    public VolumeInfo getVolumeInfo() {
        return this.volume;
    }

    @Override
    public DatabaseResultSet<ACLEntry> getACL(long fileId) throws DatabaseException {
        try {
            byte[] prefix = BabuDBStorageHelper.createACLPrefixKey(fileId, null);
            ResultSet it = (ResultSet)this.database.prefixLookup(2, prefix, null).get();
            return new BabuDBStorageHelper.ACLIterator((ResultSet<byte[], byte[]>)it);
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public ACLEntry getACLEntry(long fileId, String entity) throws DatabaseException {
        try {
            byte[] key = BabuDBStorageHelper.createACLPrefixKey(fileId, entity);
            byte[] value = (byte[])this.database.lookup(2, key, null).get();
            return value == null ? null : new BufferBackedACLEntry(key, value);
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public DatabaseResultSet<FileMetadata> getChildren(long parentId, int from, int num) throws DatabaseException {
        try {
            return BabuDBStorageHelper.getChildren(this.database, parentId, from, num);
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public StripingPolicy getDefaultStripingPolicy(long fileId) throws DatabaseException {
        try {
            byte[] spBytes = this.getXAttr(fileId, "", DEFAULT_SP_ATTR_NAME);
            if (spBytes == null) {
                return null;
            }
            return Converter.stringToStripingPolicy(this, new String(spBytes));
        }
        catch (DatabaseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public ReplicationPolicy getDefaultReplicationPolicy(long fileId) throws DatabaseException {
        try {
            byte[] rpBytes = this.getXAttr(fileId, "", DEFAULT_RP_ATTR_NAME);
            if (rpBytes == null) {
                return null;
            }
            return Converter.stringToReplicationPolicy(this, new String(rpBytes));
        }
        catch (DatabaseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public long getVolumeQuota() throws DatabaseException {
        try {
            byte[] quotaBytes = this.getXAttr(1L, "", VOL_QUOTA);
            if (quotaBytes == null) {
                return 0L;
            }
            return Long.valueOf(new String(quotaBytes));
        }
        catch (DatabaseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public FileMetadata getMetadata(long fileId) throws DatabaseException {
        ResultSet it = null;
        try {
            Map.Entry curr;
            byte[] key = BabuDBStorageHelper.createFileIdIndexKey(fileId, (byte)-1);
            ByteBuffer.wrap(key).putLong(fileId);
            byte[][] valBufs = new byte[2][];
            it = (ResultSet)this.database.prefixLookup(3, key, null).get();
            while (it.hasNext()) {
                curr = (Map.Entry)it.next();
                byte type = BabuDBStorageHelper.getType((byte[])curr.getKey(), 3);
                if (type == 3) {
                    long parentId = ByteBuffer.wrap((byte[])curr.getValue()).getLong();
                    String fileName = new String((byte[])curr.getValue(), 8, ((byte[])curr.getValue()).length - 8);
                    FileMetadata fileMetadata = this.getMetadata(parentId, fileName);
                    return fileMetadata;
                }
                valBufs[type] = (byte[])curr.getValue();
            }
            if (valBufs[1] == null) {
                curr = null;
                return curr;
            }
            byte[][] keyBufs = new byte[][]{null, BabuDBStorageHelper.createFileKey(0L, "", (byte)1)};
            BufferBackedFileMetadata bufferBackedFileMetadata = new BufferBackedFileMetadata(keyBufs, valBufs, 3);
            return bufferBackedFileMetadata;
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
        finally {
            if (it != null) {
                it.free();
            }
        }
    }

    @Override
    public FileMetadata getMetadata(long parentId, String fileName) throws DatabaseException {
        try {
            return BabuDBStorageHelper.getMetadata(this.database, parentId, fileName);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public String getSoftlinkTarget(long fileId) throws DatabaseException {
        try {
            byte[] target = this.getXAttr(fileId, "", LINK_TARGET_ATTR_NAME);
            return target == null ? null : new String(target);
        }
        catch (DatabaseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public byte[] getXAttr(long fileId, String uid, String key) throws DatabaseException {
        ResultSet it = null;
        try {
            byte[] prefix = BabuDBStorageHelper.createXAttrPrefixKey(fileId, uid, key);
            it = (ResultSet)this.database.prefixLookup(1, prefix, null).get();
            while (it.hasNext()) {
                Map.Entry curr = (Map.Entry)it.next();
                BufferBackedXAttr xattr = new BufferBackedXAttr((byte[])curr.getKey(), (byte[])curr.getValue());
                if (!uid.equals(xattr.getOwner()) || !key.equals(xattr.getKey())) continue;
                byte[] byArray = xattr.getValue();
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
        finally {
            if (it != null) {
                it.free();
            }
        }
    }

    @Override
    public DatabaseResultSet<XAttr> getXAttrs(long fileId) throws DatabaseException {
        try {
            byte[] prefix = BabuDBStorageHelper.createXAttrPrefixKey(fileId, null, null);
            ResultSet it = (ResultSet)this.database.prefixLookup(1, prefix, null).get();
            return new BabuDBStorageHelper.XAttrIterator((ResultSet<byte[], byte[]>)it, null);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public DatabaseResultSet<XAttr> getXAttrs(long fileId, String uid) throws DatabaseException {
        try {
            byte[] prefix = BabuDBStorageHelper.createXAttrPrefixKey(fileId, uid, null);
            ResultSet it = (ResultSet)this.database.prefixLookup(1, prefix, null).get();
            return new BabuDBStorageHelper.XAttrIterator((ResultSet<byte[], byte[]>)it, uid);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public FileMetadata[] resolvePath(Path path) throws DatabaseException {
        try {
            FileMetadata[] md = new FileMetadata[path.getCompCount()];
            long parentId = this.rootParentId;
            for (int i = 0; i < md.length; ++i) {
                md[i] = BabuDBStorageHelper.getMetadata(this.database, parentId, i == 0 ? this.rootDirName : path.getComp(i));
                if (md[i] == null || i < md.length - 1 && !md[i].isDirectory()) {
                    md[i] = null;
                    return md;
                }
                parentId = md[i].getId();
            }
            return md;
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    protected long getVolumeSize() throws DatabaseException {
        try {
            byte[] sizeBytes = BabuDBStorageHelper.getVolumeMetadata(this.database, VOL_SIZE_KEY);
            return ByteBuffer.wrap(sizeBytes).getLong(0);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    protected long getNumFiles() throws DatabaseException {
        try {
            byte[] sizeBytes = BabuDBStorageHelper.getVolumeMetadata(this.database, NUM_FILES_KEY);
            return ByteBuffer.wrap(sizeBytes).getLong(0);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    protected long getNumDirs() throws DatabaseException {
        try {
            byte[] sizeBytes = BabuDBStorageHelper.getVolumeMetadata(this.database, NUM_DIRS_KEY);
            return ByteBuffer.wrap(sizeBytes).getLong(0);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public void addVolumeChangeListener(VolumeChangeListener listener) {
    }

    @Override
    public ACLEntry createACLEntry(long fileId, String entity, short rights) {
        return null;
    }

    @Override
    public AtomicDBUpdate createAtomicDBUpdate(DBAccessResultListener<Object> listener, Object context) throws DatabaseException {
        try {
            return new AtomicBabuDBSnapshotUpdate((DatabaseRequestListener<Object>)(listener == null ? null : new BabuDBRequestListenerWrapper<Object>(listener)), context);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public FileMetadata createDir(long fileId, long parentId, String fileName, int atime, int ctime, int mtime, String userId, String groupId, int perms, long w32Attrs, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
        return null;
    }

    @Override
    public FileMetadata createFile(long fileId, long parentId, String fileName, int atime, int ctime, int mtime, String userId, String groupId, int perms, long w32Attrs, long size, boolean readOnly, int epoch, int issEpoch, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
        return null;
    }

    @Override
    public void createSnapshot(String snapName, long parentId, String dirName, boolean recursive) throws DatabaseException {
        this.throwException();
    }

    @Override
    public StripingPolicy createStripingPolicy(String pattern, int stripeSize, int width) {
        return null;
    }

    @Override
    public FileMetadata createSymLink(long fileId, long parentId, String fileName, int atime, int ctime, int mtime, String userId, String groupId, String ref, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
        return null;
    }

    @Override
    public XAttr createXAttr(long fileId, String owner, String key, byte[] value) {
        return null;
    }

    @Override
    public XLoc createXLoc(StripingPolicy stripingPolicy, String[] osds, int replFlags) {
        return null;
    }

    @Override
    public XLocList createXLocList(XLoc[] replicas, String replUpdatePolicy, int version) {
        return null;
    }

    @Override
    public short delete(long parentId, String fileName, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
        return -1;
    }

    @Override
    public void deleteDatabase() throws DatabaseException {
        this.throwException();
    }

    @Override
    public void deleteSnapshot(String snapName) throws DatabaseException {
        this.throwException();
    }

    @Override
    public void dumpDB(BufferedWriter xmlWriter) throws DatabaseException, IOException {
        DBAdminHelper.dumpVolume(xmlWriter, this);
    }

    @Override
    public String[] getAllSnapshots() throws DatabaseException {
        this.throwException();
        return null;
    }

    @Override
    public long getNextFileId() throws DatabaseException {
        this.throwException();
        return -1L;
    }

    @Override
    public void link(FileMetadata metadata, long newParentId, String newFileName, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
    }

    @Override
    public void setACLEntry(long fileId, String entity, Short rights, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
    }

    @Override
    public void setDefaultStripingPolicy(long fileId, GlobalTypes.StripingPolicy defaultSp, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
    }

    @Override
    public void setDefaultReplicationPolicy(long fileId, ReplicationPolicy defaultRp, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
    }

    @Override
    public void setVolumeQuota(long quota, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
    }

    @Override
    public void setLastFileId(long fileId, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
    }

    @Override
    public void setMetadata(FileMetadata metadata, byte type, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
    }

    @Override
    public void setXAttr(long fileId, String uid, String key, byte[] value, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
    }

    @Override
    public short unlink(long parentId, String fileName, AtomicDBUpdate update) throws DatabaseException {
        this.throwException();
        return -1;
    }

    protected String getVolumeName() {
        return this.volumeName;
    }

    protected void throwException() throws DatabaseException {
        throw new DatabaseException("cannot invoke this operation on a snapshot", DatabaseException.ExceptionType.NOT_ALLOWED);
    }
}

