/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.database.babudb;

import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.babudb.BabuDBSnapshotStorageManager;
import org.xtreemfs.mrc.utils.Converter;

public class BabuDBSnapshotVolumeInfo
implements VolumeInfo {
    private String id;
    private String name;
    private short[] osdPolicy;
    private short[] replicaPolicy;
    private short acPolicy;
    private long creationTimestamp;
    private BabuDBSnapshotStorageManager sMan;

    public BabuDBSnapshotVolumeInfo(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public void init(BabuDBSnapshotStorageManager sMan) throws DatabaseException {
        this.sMan = sMan;
        try {
            this.id = new String(sMan.getXAttr(1L, "", "volId"));
            this.name = sMan.getVolumeName();
            this.osdPolicy = Converter.stringToShortArray(new String(sMan.getXAttr(1L, "", "osdPol")));
            this.replicaPolicy = Converter.stringToShortArray(new String(sMan.getXAttr(1L, "", "replPol")));
            this.acPolicy = Short.parseShort(new String(sMan.getXAttr(1L, "", "acPol")));
        }
        catch (NumberFormatException exc) {
            Logging.logError(3, this, exc);
            throw new DatabaseException("currpted MRC database", DatabaseException.ExceptionType.INTERNAL_DB_ERROR);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short[] getOsdPolicy() {
        return this.osdPolicy;
    }

    @Override
    public short[] getReplicaPolicy() {
        return this.replicaPolicy;
    }

    @Override
    public long getVolumeQuota() throws DatabaseException {
        return this.sMan.getVolumeQuota();
    }

    @Override
    public short getAcPolicyId() {
        return this.acPolicy;
    }

    @Override
    public void setOsdPolicy(short[] osdPolicy, AtomicDBUpdate update) throws DatabaseException {
        this.sMan.throwException();
    }

    @Override
    public void setReplicaPolicy(short[] replicaPolicy, AtomicDBUpdate update) throws DatabaseException {
        this.sMan.throwException();
    }

    @Override
    public void setVolumeQuota(long quota, AtomicDBUpdate update) throws DatabaseException {
        this.sMan.throwException();
    }

    @Override
    public void setAllowSnaps(boolean allowSnaps, AtomicDBUpdate update) throws DatabaseException {
        this.sMan.throwException();
    }

    @Override
    public void updateVolumeSize(long diff, AtomicDBUpdate update) throws DatabaseException {
        this.sMan.throwException();
    }

    @Override
    public long getNumFiles() throws DatabaseException {
        return 0L;
    }

    @Override
    public long getNumDirs() throws DatabaseException {
        return 0L;
    }

    @Override
    public long getVolumeSize() throws DatabaseException {
        return 0L;
    }

    @Override
    public boolean isSnapVolume() throws DatabaseException {
        return true;
    }

    @Override
    public boolean isSnapshotsEnabled() throws DatabaseException {
        return true;
    }

    @Override
    public long getCreationTime() throws DatabaseException {
        return this.creationTimestamp;
    }
}

