/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.database.babudb;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRO;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.babudb.BabuDBStorageManager;
import org.xtreemfs.mrc.metadata.ACLEntry;
import org.xtreemfs.mrc.metadata.BufferBackedACLEntry;
import org.xtreemfs.mrc.metadata.BufferBackedFileMetadata;
import org.xtreemfs.mrc.metadata.BufferBackedRCMetadata;
import org.xtreemfs.mrc.metadata.BufferBackedXAttr;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.XAttr;

public class BabuDBStorageHelper {
    public static byte[] getLastAssignedFileId(Database database) throws BabuDBException {
        byte[] bytes = (byte[])database.lookup(4, BabuDBStorageManager.LAST_ID_KEY, null).get();
        if (bytes == null) {
            bytes = new byte[8];
            ByteBuffer tmp = ByteBuffer.wrap(bytes);
            tmp.putLong(0L);
        }
        return bytes;
    }

    public static byte[] getVolumeMetadata(DatabaseRO database, byte[] key) throws BabuDBException {
        byte[] bytes = (byte[])database.lookup(4, key, null).get();
        if (bytes == null) {
            bytes = new byte[8];
            ByteBuffer tmp = ByteBuffer.wrap(bytes);
            tmp.putLong(0L);
        }
        return bytes;
    }

    public static short findXAttrCollisionNumber(Database database, long fileId, String owner, String attrKey) throws BabuDBException {
        byte[] prefix = BabuDBStorageHelper.createXAttrPrefixKey(fileId, owner, attrKey);
        ResultSet it = (ResultSet)database.prefixLookup(1, prefix, null).get();
        Map.Entry next = null;
        while (it.hasNext()) {
            Map.Entry curr = (Map.Entry)it.next();
            BufferBackedXAttr attr = new BufferBackedXAttr((byte[])curr.getKey(), (byte[])curr.getValue());
            if (!owner.equals(attr.getOwner()) || !attrKey.equals(attr.getKey())) continue;
            next = curr;
            break;
        }
        it.free();
        if (next == null) {
            return -1;
        }
        return BabuDBStorageHelper.getXAttrCollisionNumber((byte[])next.getKey());
    }

    public static short findUsedOrNextFreeXAttrCollisionNumber(Database database, long fileId, String owner, String attrKey) throws BabuDBException {
        byte[] prefix = BabuDBStorageHelper.createXAttrPrefixKey(fileId, owner, attrKey);
        ResultSet it = (ResultSet)database.prefixLookup(1, prefix, null).get();
        Map.Entry next = null;
        Map.Entry curr = null;
        while (it.hasNext()) {
            curr = (Map.Entry)it.next();
            BufferBackedXAttr attr = new BufferBackedXAttr((byte[])curr.getKey(), (byte[])curr.getValue());
            if (!owner.equals(attr.getOwner()) || !attrKey.equals(attr.getKey())) continue;
            next = curr;
            break;
        }
        it.free();
        if (next == null) {
            return curr == null ? (short)0 : (short)(BabuDBStorageHelper.getXAttrCollisionNumber((byte[])curr.getKey()) + 1);
        }
        return BabuDBStorageHelper.getXAttrCollisionNumber((byte[])next.getKey());
    }

    public static byte[] createFileKey(long parentId, String fileName, byte type) {
        byte[] bytes = fileName.getBytes();
        byte[] prefix = new byte[(type >= 0 ? 9 : 8) + bytes.length];
        ByteBuffer buf = ByteBuffer.wrap(prefix);
        buf.putLong(parentId).put(bytes);
        if (type >= 0) {
            buf.put(type);
        }
        return prefix;
    }

    public static byte[] createXAttrPrefixKey(long fileId, String owner, String attrKey) {
        byte[] prefix = new byte[owner == null ? 8 : (attrKey == null ? 12 : 16)];
        ByteBuffer buf = ByteBuffer.wrap(prefix);
        buf.putLong(fileId);
        if (owner != null) {
            buf.putInt(owner.hashCode());
        }
        if (attrKey != null) {
            buf.putInt(attrKey.hashCode());
        }
        return prefix;
    }

    public static byte[] createFilePrefixKey(long parentId) {
        byte[] prefix = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(prefix);
        buf.putLong(parentId);
        return prefix;
    }

    public static byte[] createACLPrefixKey(long fileId, String entityName) {
        byte[] entityBytes = entityName == null ? new byte[]{} : entityName.getBytes();
        byte[] prefix = new byte[8 + entityBytes.length];
        ByteBuffer buf = ByteBuffer.wrap(prefix);
        buf.putLong(fileId).put(entityBytes);
        return prefix;
    }

    public static byte[] createFileIdIndexValue(long parentId, String fileName) {
        byte[] nameBytes = fileName.getBytes();
        byte[] buf = new byte[8 + nameBytes.length];
        ByteBuffer tmp = ByteBuffer.wrap(buf);
        tmp.putLong(parentId).put(nameBytes);
        return buf;
    }

    public static byte[] createFileIdIndexKey(long fileId, byte type) {
        byte[] buf = new byte[type == -1 ? 8 : 9];
        ByteBuffer tmp = ByteBuffer.wrap(buf);
        tmp.putLong(fileId);
        if (type != -1) {
            tmp.put(type);
        }
        return buf;
    }

    public static byte[] createLinkTarget(long fileId) {
        byte[] buf = new byte[9];
        ByteBuffer tmp = ByteBuffer.wrap(buf);
        tmp.put((byte)2).putLong(fileId);
        return buf;
    }

    public static short getXAttrCollisionNumber(byte[] key) {
        short collNum = 0;
        ByteBuffer tmp = ByteBuffer.wrap(key);
        collNum = key.length == 16 ? (short)0 : tmp.getShort(16);
        return collNum;
    }

    public static BufferBackedFileMetadata getMetadata(DatabaseRO database, long parentId, String fileName) throws BabuDBException {
        byte[] rcKey = BabuDBStorageHelper.createFileKey(parentId, fileName, (byte)1);
        byte[] rcValue = (byte[])database.lookup(0, rcKey, null).get();
        if (rcValue != null) {
            if (rcValue[0] == 2) {
                return BabuDBStorageHelper.resolveLink(database, rcValue, fileName);
            }
            byte[] fcKey = BabuDBStorageHelper.createFileKey(parentId, fileName, (byte)0);
            byte[] fcValue = (byte[])database.lookup(0, fcKey, null).get();
            byte[][] keyBufs = new byte[][]{fcKey, rcKey};
            byte[][] valBufs = new byte[][]{fcValue, rcValue};
            return new BufferBackedFileMetadata(keyBufs, valBufs, 0);
        }
        return null;
    }

    public static long getId(Database database, long parentId, String fileName, Boolean directory) throws BabuDBException {
        byte[] key = BabuDBStorageHelper.createFileKey(parentId, fileName, (byte)1);
        byte[] value = (byte[])database.lookup(0, key, null).get();
        if (value == null) {
            return -1L;
        }
        return ByteBuffer.wrap(value).getLong(1);
    }

    public static byte getType(byte[] key, int index) {
        return key[index == 3 ? 8 : 12];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferBackedFileMetadata resolveLink(DatabaseRO database, byte[] target, String fileName) throws BabuDBException {
        ResultSet it = null;
        try {
            BufferBackedRCMetadata tmp2;
            Map.Entry curr;
            byte[] fileIdBytes = new byte[8];
            System.arraycopy(target, 1, fileIdBytes, 0, fileIdBytes.length);
            byte[][] valBufs = new byte[2][];
            it = (ResultSet)database.prefixLookup(3, fileIdBytes, null).get();
            while (it.hasNext()) {
                curr = (Map.Entry)it.next();
                byte type = BabuDBStorageHelper.getType((byte[])curr.getKey(), 3);
                if (type == 3) {
                    long fileId = ByteBuffer.wrap(fileIdBytes).getLong();
                    Logging.logMessage(4, Logging.Category.storage, (Object)null, "MRC database contains redundant data for file %d", fileId);
                    continue;
                }
                valBufs[type] = (byte[])curr.getValue();
            }
            assert (valBufs[1] != null) : "*** DATABASE CORRUPTED *** dangling hardlink";
            if (valBufs[1] == null) {
                curr = null;
                return curr;
            }
            BufferBackedRCMetadata tmp = new BufferBackedRCMetadata(null, valBufs[1]);
            BufferBackedRCMetadata bufferBackedRCMetadata = tmp2 = tmp.isDirectory() ? new BufferBackedRCMetadata(0L, fileName, tmp.getOwnerId(), tmp.getOwningGroupId(), tmp.getId(), tmp.getPerms(), tmp.getW32Attrs(), tmp.getLinkCount()) : new BufferBackedRCMetadata(0L, fileName, tmp.getOwnerId(), tmp.getOwningGroupId(), tmp.getId(), tmp.getPerms(), tmp.getW32Attrs(), tmp.getLinkCount(), tmp.getEpoch(), tmp.getIssuedEpoch(), tmp.isReadOnly());
            if (!tmp2.isDirectory()) {
                tmp2.setXLocList(tmp.getXLocList());
            }
            valBufs[1] = tmp2.getValue();
            byte[][] keyBufs = new byte[][]{null, tmp2.getKey()};
            BufferBackedFileMetadata bufferBackedFileMetadata = new BufferBackedFileMetadata(keyBufs, valBufs, 3);
            return bufferBackedFileMetadata;
        }
        finally {
            if (it != null) {
                it.free();
            }
        }
    }

    public static ChildrenIterator getChildren(DatabaseRO database, long parentId, int from, int num) throws BabuDBException {
        byte[] prefix = BabuDBStorageHelper.createFilePrefixKey(parentId);
        ResultSet it = (ResultSet)database.prefixLookup(0, prefix, null).get();
        return new ChildrenIterator(database, (ResultSet<byte[], byte[]>)it, from, num);
    }

    public static void getNestedFiles(List<FileMetadata> files, Database database, long dirId, boolean recursive) throws BabuDBException {
        ChildrenIterator children = BabuDBStorageHelper.getChildren((DatabaseRO)database, dirId, 0, Integer.MAX_VALUE);
        while (children.hasNext()) {
            FileMetadata metadata = children.next();
            files.add(metadata);
            if (!recursive || !metadata.isDirectory()) continue;
            BabuDBStorageHelper.getNestedFiles(files, database, metadata.getId(), recursive);
        }
        children.destroy();
    }

    public static long getRootParentId(DatabaseRO database) throws BabuDBException {
        ResultSet it = (ResultSet)database.prefixLookup(0, null, null).get();
        if (!it.hasNext()) {
            return -1L;
        }
        byte[] key = (byte[])((Map.Entry)it.next()).getKey();
        it.free();
        return ByteBuffer.wrap(key).getLong();
    }

    public static String getRootDirName(DatabaseRO database, long rootParentId) throws BabuDBException {
        byte[] rootParentIdBytes = ByteBuffer.wrap(new byte[8]).putLong(rootParentId).array();
        ResultSet it = (ResultSet)database.prefixLookup(0, rootParentIdBytes, null).get();
        if (!it.hasNext()) {
            return null;
        }
        byte[] key = (byte[])((Map.Entry)it.next()).getKey();
        it.free();
        return new String(key, 8, key.length - 9);
    }

    static class ACLIterator
    implements DatabaseResultSet<ACLEntry> {
        private ResultSet<byte[], byte[]> it;

        public ACLIterator(ResultSet<byte[], byte[]> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ACLEntry next() {
            Map.Entry entry = (Map.Entry)this.it.next();
            return new BufferBackedACLEntry((byte[])entry.getKey(), (byte[])entry.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void destroy() {
            this.it.free();
        }
    }

    static class XAttrIterator
    implements DatabaseResultSet<XAttr> {
        private ResultSet<byte[], byte[]> it;
        private String owner;
        private BufferBackedXAttr next;

        public XAttrIterator(ResultSet<byte[], byte[]> it, String owner) {
            this.it = it;
            this.owner = owner;
        }

        @Override
        public boolean hasNext() {
            if (this.owner == null) {
                return this.it.hasNext();
            }
            if (this.next != null) {
                return true;
            }
            if (!this.it.hasNext()) {
                return false;
            }
            while (this.it.hasNext()) {
                Map.Entry tmp = (Map.Entry)this.it.next();
                this.next = new BufferBackedXAttr((byte[])tmp.getKey(), (byte[])tmp.getValue());
                if (!this.owner.equals(this.next.getOwner())) continue;
                return true;
            }
            return false;
        }

        @Override
        public XAttr next() {
            if (this.next != null) {
                BufferBackedXAttr tmp = this.next;
                this.next = null;
                return tmp;
            }
            do {
                Map.Entry tmp = (Map.Entry)this.it.next();
                this.next = new BufferBackedXAttr((byte[])tmp.getKey(), (byte[])tmp.getValue());
            } while (this.owner != null && !this.owner.equals(this.next.getOwner()));
            BufferBackedXAttr tmp2 = this.next;
            this.next = null;
            return tmp2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void destroy() {
            this.it.free();
        }
    }

    static class ChildrenIterator
    implements DatabaseResultSet<FileMetadata> {
        private final DatabaseRO database;
        private final ResultSet<byte[], byte[]> it;
        private Map.Entry<byte[], byte[]> next;
        private String prevFileName;
        private byte[][] keyBufs;
        private byte[][] valBufs;
        private int remaining;

        public ChildrenIterator(DatabaseRO database, ResultSet<byte[], byte[]> it, int from, int num) {
            this.database = database;
            this.it = it;
            this.keyBufs = new byte[2][];
            this.valBufs = new byte[2][];
            this.remaining = Integer.MAX_VALUE;
            for (int i = 0; i < from && this.hasNext(); ++i) {
                this.next();
            }
            this.remaining = num;
        }

        @Override
        public boolean hasNext() {
            return (this.next != null || this.it.hasNext()) && this.remaining > 0;
        }

        @Override
        public FileMetadata next() {
            while (this.next != null || this.it.hasNext()) {
                if (this.next == null) {
                    this.next = (Map.Entry)this.it.next();
                }
                String currFileName = new String(this.next.getKey(), 8, this.next.getKey().length - 9);
                if (this.prevFileName != null && !this.prevFileName.equals(currFileName)) {
                    assert (this.valBufs[1] != null) : "*** DATABASE CORRUPTED *** incomplete file metadata";
                    break;
                }
                byte currType = this.next.getKey()[this.next.getKey().length - 1];
                this.keyBufs[currType] = this.next.getKey();
                this.valBufs[currType] = this.next.getValue();
                this.next = null;
                this.prevFileName = currFileName;
            }
            byte[][] tmpKeys = this.keyBufs;
            byte[][] tmpVals = this.valBufs;
            this.keyBufs = new byte[2][];
            this.valBufs = new byte[2][];
            BufferBackedFileMetadata md = null;
            if (tmpVals[1][0] == 2) {
                try {
                    md = BabuDBStorageHelper.resolveLink(this.database, tmpVals[1], this.prevFileName);
                }
                catch (BabuDBException exc) {
                    Logging.logMessage(3, Logging.Category.storage, this, "could not resolve hard link", new Object[0]);
                }
            } else {
                md = new BufferBackedFileMetadata(tmpKeys, tmpVals, 0);
            }
            --this.remaining;
            this.prevFileName = null;
            return md;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void destroy() {
            this.it.free();
        }
    }
}

