/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.database.babudb;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xtreemfs.babudb.api.BabuDB;
import org.xtreemfs.babudb.api.DatabaseManager;
import org.xtreemfs.babudb.api.SnapshotManager;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRO;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.index.DefaultByteRangeComparator;
import org.xtreemfs.babudb.snapshots.DefaultSnapshotConfig;
import org.xtreemfs.babudb.snapshots.SnapshotConfig;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DBAccessResultListener;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeChangeListener;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.babudb.AtomicBabuDBUpdate;
import org.xtreemfs.mrc.database.babudb.BabuDBRequestListenerWrapper;
import org.xtreemfs.mrc.database.babudb.BabuDBStorageHelper;
import org.xtreemfs.mrc.database.babudb.BabuDBVolumeInfo;
import org.xtreemfs.mrc.database.babudb.TransactionalBabuDBUpdate;
import org.xtreemfs.mrc.metadata.ACLEntry;
import org.xtreemfs.mrc.metadata.BufferBackedACLEntry;
import org.xtreemfs.mrc.metadata.BufferBackedFileMetadata;
import org.xtreemfs.mrc.metadata.BufferBackedStripingPolicy;
import org.xtreemfs.mrc.metadata.BufferBackedXAttr;
import org.xtreemfs.mrc.metadata.BufferBackedXLoc;
import org.xtreemfs.mrc.metadata.BufferBackedXLocList;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.ReplicationPolicy;
import org.xtreemfs.mrc.metadata.StripingPolicy;
import org.xtreemfs.mrc.metadata.XAttr;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.DBAdminHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class BabuDBStorageManager
implements StorageManager {
    public static final int FILE_INDEX = 0;
    public static final int XATTRS_INDEX = 1;
    public static final int ACL_INDEX = 2;
    public static final int FILE_ID_INDEX = 3;
    public static final int VOLUME_INDEX = 4;
    public static final byte[] LAST_ID_KEY = new byte[]{105};
    public static final byte[] VOL_SIZE_KEY = new byte[]{115};
    public static final byte[] NUM_FILES_KEY = new byte[]{102};
    public static final byte[] NUM_DIRS_KEY = new byte[]{100};
    private static final String DEFAULT_SP_ATTR_NAME = "sp";
    private static final String DEFAULT_RP_ATTR_NAME = "rp";
    private static final String LINK_TARGET_ATTR_NAME = "lt";
    protected static final String OSD_POL_ATTR_NAME = "osdPol";
    protected static final String REPL_POL_ATTR_NAME = "replPol";
    protected static final String AC_POL_ATTR_NAME = "acPol";
    protected static final String AUTO_REPL_FACTOR_ATTR_NAME = "replFactor";
    protected static final String AUTO_REPL_FULL_ATTR_NAME = "replFull";
    protected static final String ALLOW_SNAPS_ATTR_NAME = "allowSnaps";
    protected static final String VOL_ID_ATTR_NAME = "volId";
    protected static final String VOL_QUOTA_ATTR_NAME = "quota";
    protected static final int[] ALL_INDICES = new int[]{0, 1, 2, 3, 4};
    private final DatabaseManager dbMan;
    private final SnapshotManager snapMan;
    private final Database database;
    private final List<VolumeChangeListener> vcListeners;
    private final BabuDBVolumeInfo volume;

    public BabuDBStorageManager(BabuDB dbs, Database db) throws DatabaseException {
        this.dbMan = dbs.getDatabaseManager();
        this.snapMan = dbs.getSnapshotManager();
        this.database = db;
        this.vcListeners = new LinkedList<VolumeChangeListener>();
        this.volume = new BabuDBVolumeInfo();
        this.volume.init(this);
    }

    public BabuDBStorageManager(DatabaseManager dbMan, SnapshotManager sMan, Database db) throws DatabaseException {
        this.dbMan = dbMan;
        this.snapMan = sMan;
        this.database = db;
        this.vcListeners = new LinkedList<VolumeChangeListener>();
        this.volume = new BabuDBVolumeInfo();
        this.volume.init(this);
    }

    public BabuDBStorageManager(BabuDB dbs, String volumeId, String volumeName, short fileAccessPolicyId, short[] osdPolicy, short[] replPolicy, String ownerId, String owningGroupId, int perms, ACLEntry[] acl, GlobalTypes.StripingPolicy rootDirDefSp, boolean allowSnaps, long volumeQuota, Map<String, String> attrs) throws DatabaseException {
        this.dbMan = dbs.getDatabaseManager();
        this.snapMan = dbs.getSnapshotManager();
        this.vcListeners = new LinkedList<VolumeChangeListener>();
        this.volume = new BabuDBVolumeInfo();
        TransactionalBabuDBUpdate update = new TransactionalBabuDBUpdate(this.dbMan);
        update.createDatabase(volumeId, 5);
        int time = (int)(TimeSync.getGlobalTime() / 1000L);
        this.createDir(1L, 0L, volumeName, time, time, time, ownerId, owningGroupId, perms, 0L, true, update);
        this.setLastFileId(1L, update);
        this.volume.init(this, update.getDatabaseName(), volumeName, osdPolicy, replPolicy, fileAccessPolicyId, allowSnaps, volumeQuota, update);
        if (rootDirDefSp != null) {
            this.setDefaultStripingPolicy(1L, rootDirDefSp, true, update);
        }
        if (acl != null) {
            for (ACLEntry entry : acl) {
                this.setACLEntry(1L, entry.getEntity(), entry.getRights(), update);
            }
        }
        if (attrs != null) {
            for (Map.Entry<String, String> attr : attrs.entrySet()) {
                this.setXAttr(1L, "", "xtreemfs.volattr." + attr.getKey(), attr.getValue().getBytes(), true, update);
            }
        }
        update.execute();
        try {
            this.database = this.dbMan.getDatabase(update.getDatabaseName());
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
        this.notifyVolumeChange(this.volume);
    }

    @Override
    public VolumeInfo getVolumeInfo() {
        return this.volume;
    }

    @Override
    public void deleteDatabase() throws DatabaseException {
        try {
            this.dbMan.deleteDatabase(this.database.getName());
            this.notifyVolumeDelete(this.volume.getId());
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public void addVolumeChangeListener(VolumeChangeListener listener) {
        this.vcListeners.add(listener);
        this.notifyVolumeChange(this.volume);
    }

    @Override
    public AtomicDBUpdate createAtomicDBUpdate(DBAccessResultListener<Object> listener, Object context) throws DatabaseException {
        try {
            return new AtomicBabuDBUpdate(this.database, (DatabaseRequestListener<Object>)(listener == null ? null : new BabuDBRequestListenerWrapper<Object>(listener)), context);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public ACLEntry createACLEntry(long fileId, String entity, short rights) {
        return new BufferBackedACLEntry(fileId, entity, rights);
    }

    @Override
    public XLoc createXLoc(StripingPolicy stripingPolicy, String[] osds, int replFlags) {
        assert (stripingPolicy instanceof BufferBackedStripingPolicy);
        return new BufferBackedXLoc((BufferBackedStripingPolicy)stripingPolicy, osds, replFlags);
    }

    @Override
    public XLocList createXLocList(XLoc[] replicas, String replUpdatePolicy, int version) {
        BufferBackedXLoc[] tmp = new BufferBackedXLoc[replicas.length];
        for (int i = 0; i < replicas.length; ++i) {
            tmp[i] = (BufferBackedXLoc)replicas[i];
        }
        return new BufferBackedXLocList(tmp, replUpdatePolicy, version);
    }

    @Override
    public StripingPolicy createStripingPolicy(String pattern, int stripeSize, int width) {
        return new BufferBackedStripingPolicy(pattern, stripeSize, width);
    }

    @Override
    public XAttr createXAttr(long fileId, String owner, String key, byte[] value) {
        return new BufferBackedXAttr(fileId, owner, key, value, 0);
    }

    @Override
    public long getNextFileId() throws DatabaseException {
        try {
            byte[] idBytes = BabuDBStorageHelper.getLastAssignedFileId(this.database);
            ByteBuffer tmp = ByteBuffer.wrap(idBytes);
            long id = tmp.getLong(0) + 1L;
            return id;
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public void setLastFileId(long fileId, AtomicDBUpdate update) throws DatabaseException {
        byte[] idBytes = new byte[8];
        ByteBuffer.wrap(idBytes).putLong(0, fileId);
        update.addUpdate(4, LAST_ID_KEY, idBytes);
    }

    @Override
    public FileMetadata createDir(long fileId, long parentId, String fileName, int atime, int ctime, int mtime, String userId, String groupId, int perms, long w32Attrs, AtomicDBUpdate update) throws DatabaseException {
        return this.createDir(fileId, parentId, fileName, atime, ctime, mtime, userId, groupId, perms, w32Attrs, false, update);
    }

    public FileMetadata createDir(long fileId, long parentId, String fileName, int atime, int ctime, int mtime, String userId, String groupId, int perms, long w32Attrs, boolean initCount, AtomicDBUpdate update) throws DatabaseException {
        BufferBackedFileMetadata fileMetadata = new BufferBackedFileMetadata(parentId, fileName, userId, groupId, fileId, atime, ctime, mtime, perms, w32Attrs, 1);
        update.addUpdate(0, fileMetadata.getFCMetadataKey(), fileMetadata.getFCMetadataValue());
        update.addUpdate(0, fileMetadata.getRCMetadata().getKey(), fileMetadata.getRCMetadata().getValue());
        update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(fileId, (byte)3), BabuDBStorageHelper.createFileIdIndexValue(parentId, fileName));
        if (initCount) {
            this.initCount(NUM_DIRS_KEY, update);
        } else {
            this.updateCount(NUM_DIRS_KEY, true, update);
        }
        return fileMetadata;
    }

    @Override
    public FileMetadata createFile(long fileId, long parentId, String fileName, int atime, int ctime, int mtime, String userId, String groupId, int perms, long w32Attrs, long size, boolean readOnly, int epoch, int issEpoch, AtomicDBUpdate update) throws DatabaseException {
        BufferBackedFileMetadata fileMetadata = new BufferBackedFileMetadata(parentId, fileName, userId, groupId, fileId, atime, ctime, mtime, size, perms, w32Attrs, 1, epoch, issEpoch, readOnly);
        update.addUpdate(0, fileMetadata.getFCMetadataKey(), fileMetadata.getFCMetadataValue());
        update.addUpdate(0, fileMetadata.getRCMetadata().getKey(), fileMetadata.getRCMetadata().getValue());
        update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(fileId, (byte)3), BabuDBStorageHelper.createFileIdIndexValue(parentId, fileName));
        this.volume.updateVolumeSize(size, update);
        this.updateCount(NUM_FILES_KEY, true, update);
        return fileMetadata;
    }

    @Override
    public FileMetadata createSymLink(long fileId, long parentId, String fileName, int atime, int ctime, int mtime, String userId, String groupId, String ref, AtomicDBUpdate update) {
        BufferBackedFileMetadata fileMetadata = new BufferBackedFileMetadata(parentId, fileName, userId, groupId, fileId, atime, ctime, mtime, ref.length(), 511, 0L, 1, 0, 0, false);
        BufferBackedXAttr lt = new BufferBackedXAttr(fileId, "", LINK_TARGET_ATTR_NAME, ref.getBytes(), 0);
        update.addUpdate(1, lt.getKeyBuf(), lt.getValBuf());
        update.addUpdate(0, fileMetadata.getFCMetadataKey(), fileMetadata.getFCMetadataValue());
        update.addUpdate(0, fileMetadata.getRCMetadata().getKey(), fileMetadata.getRCMetadata().getValue());
        update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(fileId, (byte)3), BabuDBStorageHelper.createFileIdIndexValue(parentId, fileName));
        return fileMetadata;
    }

    @Override
    public short unlink(long parentId, String fileName, AtomicDBUpdate update) throws DatabaseException {
        try {
            BufferBackedFileMetadata file = BabuDBStorageHelper.getMetadata((DatabaseRO)this.database, parentId, fileName);
            short newLinkCount = (short)(file.getLinkCount() - 1);
            file.setLinkCount(newLinkCount);
            if (newLinkCount > 0) {
                update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(file.getId(), (byte)1), file.getRCMetadata().getValue());
            }
            update.addUpdate(0, BabuDBStorageHelper.createFileKey(parentId, fileName, (byte)0), null);
            update.addUpdate(0, BabuDBStorageHelper.createFileKey(parentId, fileName, (byte)1), null);
            return newLinkCount;
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public short delete(long parentId, String fileName, AtomicDBUpdate update) throws DatabaseException {
        try {
            BufferBackedFileMetadata file = BabuDBStorageHelper.getMetadata((DatabaseRO)this.database, parentId, fileName);
            short newLinkCount = (short)(file.getLinkCount() - 1);
            assert (newLinkCount >= 0);
            file.setLinkCount(newLinkCount);
            if (newLinkCount > 0) {
                update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(file.getId(), (byte)1), file.getRCMetadata().getValue());
            }
            update.addUpdate(0, BabuDBStorageHelper.createFileKey(parentId, fileName, (byte)0), null);
            update.addUpdate(0, BabuDBStorageHelper.createFileKey(parentId, fileName, (byte)1), null);
            if (newLinkCount == 0) {
                update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(file.getId(), (byte)3), null);
                update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(file.getId(), (byte)0), null);
                update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(file.getId(), (byte)1), null);
                byte[] idBytes = new byte[8];
                ByteBuffer.wrap(idBytes).putLong(file.getId());
                ResultSet it = (ResultSet)this.database.prefixLookup(2, idBytes, null).get();
                while (it.hasNext()) {
                    update.addUpdate(2, ((Map.Entry)it.next()).getKey(), null);
                }
                it.free();
                it = (ResultSet)this.database.prefixLookup(1, idBytes, null).get();
                while (it.hasNext()) {
                    update.addUpdate(1, ((Map.Entry)it.next()).getKey(), null);
                }
                it.free();
                if (file.isDirectory()) {
                    this.updateCount(NUM_DIRS_KEY, false, update);
                } else if (file.getXLocList() != null) {
                    this.volume.updateVolumeSize(-file.getSize(), update);
                    this.updateCount(NUM_FILES_KEY, false, update);
                }
            }
            return file.getLinkCount();
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public DatabaseResultSet<ACLEntry> getACL(long fileId) throws DatabaseException {
        try {
            byte[] prefix = BabuDBStorageHelper.createACLPrefixKey(fileId, null);
            ResultSet it = (ResultSet)this.database.prefixLookup(2, prefix, null).get();
            return new BabuDBStorageHelper.ACLIterator((ResultSet<byte[], byte[]>)it);
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public ACLEntry getACLEntry(long fileId, String entity) throws DatabaseException {
        try {
            byte[] key = BabuDBStorageHelper.createACLPrefixKey(fileId, entity);
            byte[] value = (byte[])this.database.lookup(2, key, null).get();
            return value == null ? null : new BufferBackedACLEntry(key, value);
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public DatabaseResultSet<FileMetadata> getChildren(long parentId, int seen, int num) throws DatabaseException {
        try {
            return BabuDBStorageHelper.getChildren((DatabaseRO)this.database, parentId, seen, num);
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public StripingPolicy getDefaultStripingPolicy(long fileId) throws DatabaseException {
        try {
            byte[] sp = this.getXAttr(fileId, "", DEFAULT_SP_ATTR_NAME);
            if (sp == null) {
                return null;
            }
            return Converter.stringToStripingPolicy(this, new String(sp));
        }
        catch (DatabaseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public ReplicationPolicy getDefaultReplicationPolicy(long fileId) throws DatabaseException {
        try {
            byte[] rp = this.getXAttr(fileId, "", DEFAULT_RP_ATTR_NAME);
            if (rp == null) {
                return null;
            }
            return Converter.stringToReplicationPolicy(this, new String(rp));
        }
        catch (DatabaseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public long getVolumeQuota() throws DatabaseException {
        try {
            byte[] quota = this.getXAttr(1L, "", VOL_QUOTA_ATTR_NAME);
            if (quota == null) {
                return 0L;
            }
            return Long.valueOf(new String(quota));
        }
        catch (DatabaseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public FileMetadata getMetadata(long fileId) throws DatabaseException {
        try {
            byte[] key = BabuDBStorageHelper.createFileIdIndexKey(fileId, (byte)-1);
            ByteBuffer.wrap(key).putLong(fileId);
            byte[][] valBufs = new byte[2][];
            ResultSet it = (ResultSet)this.database.prefixLookup(3, key, null).get();
            while (it.hasNext()) {
                Map.Entry curr = (Map.Entry)it.next();
                byte type = BabuDBStorageHelper.getType((byte[])curr.getKey(), 3);
                if (type == 3) {
                    long parentId = ByteBuffer.wrap((byte[])curr.getValue()).getLong();
                    String fileName = new String((byte[])curr.getValue(), 8, ((byte[])curr.getValue()).length - 8);
                    return this.getMetadata(parentId, fileName);
                }
                valBufs[type] = (byte[])curr.getValue();
            }
            it.free();
            if (valBufs[1] == null) {
                return null;
            }
            byte[][] keyBufs = new byte[][]{null, BabuDBStorageHelper.createFileKey(0L, "", (byte)1)};
            return new BufferBackedFileMetadata(keyBufs, valBufs, 3);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public FileMetadata getMetadata(long parentId, String fileName) throws DatabaseException {
        try {
            return BabuDBStorageHelper.getMetadata((DatabaseRO)this.database, parentId, fileName);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public String getSoftlinkTarget(long fileId) throws DatabaseException {
        try {
            byte[] target = this.getXAttr(fileId, "", LINK_TARGET_ATTR_NAME);
            return target == null ? null : new String(target);
        }
        catch (DatabaseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public byte[] getXAttr(long fileId, String uid, String key) throws DatabaseException {
        ResultSet it = null;
        try {
            byte[] prefix = BabuDBStorageHelper.createXAttrPrefixKey(fileId, uid, key);
            it = (ResultSet)this.database.prefixLookup(1, prefix, null).get();
            while (it.hasNext()) {
                Map.Entry curr = (Map.Entry)it.next();
                BufferBackedXAttr xattr = new BufferBackedXAttr((byte[])curr.getKey(), (byte[])curr.getValue());
                if (!uid.equals(xattr.getOwner()) || !key.equals(xattr.getKey())) continue;
                byte[] byArray = xattr.getValue();
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
        finally {
            if (it != null) {
                it.free();
            }
        }
    }

    @Override
    public DatabaseResultSet<XAttr> getXAttrs(long fileId) throws DatabaseException {
        try {
            byte[] prefix = BabuDBStorageHelper.createXAttrPrefixKey(fileId, null, null);
            ResultSet it = (ResultSet)this.database.prefixLookup(1, prefix, null).get();
            return new BabuDBStorageHelper.XAttrIterator((ResultSet<byte[], byte[]>)it, null);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public DatabaseResultSet<XAttr> getXAttrs(long fileId, String uid) throws DatabaseException {
        try {
            byte[] prefix = BabuDBStorageHelper.createXAttrPrefixKey(fileId, uid, null);
            ResultSet it = (ResultSet)this.database.prefixLookup(1, prefix, null).get();
            return new BabuDBStorageHelper.XAttrIterator((ResultSet<byte[], byte[]>)it, uid);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public void link(FileMetadata metadata, long newParentId, String newFileName, AtomicDBUpdate update) {
        BufferBackedFileMetadata md = (BufferBackedFileMetadata)metadata;
        short links = metadata.getLinkCount();
        md.setLinkCount((short)(links + 1));
        update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(metadata.getId(), (byte)0), md.getFCMetadataValue());
        update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(metadata.getId(), (byte)1), md.getRCMetadata().getValue());
        update.addUpdate(3, BabuDBStorageHelper.createFileIdIndexKey(metadata.getId(), (byte)3), null);
        if (links != 0 && md.getIndexId() == 0) {
            update.addUpdate(0, md.getRCMetadata().getKey(), BabuDBStorageHelper.createLinkTarget(metadata.getId()));
            update.addUpdate(0, md.getFCMetadataKey(), null);
        }
        update.addUpdate(0, BabuDBStorageHelper.createFileKey(newParentId, newFileName, (byte)1), BabuDBStorageHelper.createLinkTarget(metadata.getId()));
    }

    @Override
    public FileMetadata[] resolvePath(Path path) throws DatabaseException {
        try {
            FileMetadata[] md = new FileMetadata[path.getCompCount()];
            long parentId = 0L;
            for (int i = 0; i < md.length; ++i) {
                md[i] = BabuDBStorageHelper.getMetadata((DatabaseRO)this.database, parentId, path.getComp(i));
                if (md[i] == null || i < md.length - 1 && !md[i].isDirectory()) {
                    md[i] = null;
                    return md;
                }
                parentId = md[i].getId();
            }
            return md;
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public void setACLEntry(long fileId, String entity, Short rights, AtomicDBUpdate update) throws DatabaseException {
        BufferBackedACLEntry entry = new BufferBackedACLEntry(fileId, entity, rights == null ? (short)0 : rights);
        update.addUpdate(2, entry.getKeyBuf(), rights == null ? null : entry.getValBuf());
    }

    @Override
    public void setDefaultStripingPolicy(long fileId, GlobalTypes.StripingPolicy defaultSp, AtomicDBUpdate update) throws DatabaseException {
        this.setDefaultStripingPolicy(fileId, defaultSp, false, update);
    }

    public void setDefaultStripingPolicy(long fileId, GlobalTypes.StripingPolicy defaultSp, boolean init, AtomicDBUpdate update) throws DatabaseException {
        this.setXAttr(fileId, "", DEFAULT_SP_ATTR_NAME, Converter.stripingPolicyToString(defaultSp).getBytes(), init, update);
    }

    @Override
    public void setDefaultReplicationPolicy(long fileId, ReplicationPolicy defaultRp, AtomicDBUpdate update) throws DatabaseException {
        this.setXAttr(fileId, "", DEFAULT_RP_ATTR_NAME, Converter.replicationPolicyToString(defaultRp).getBytes(), update);
    }

    @Override
    public void setVolumeQuota(long quota, AtomicDBUpdate update) throws DatabaseException {
        this.setXAttr(1L, "", VOL_QUOTA_ATTR_NAME, String.valueOf(quota).getBytes(), update);
    }

    @Override
    public void setMetadata(FileMetadata metadata, byte type, AtomicDBUpdate update) throws DatabaseException {
        assert (metadata instanceof BufferBackedFileMetadata);
        BufferBackedFileMetadata md = (BufferBackedFileMetadata)metadata;
        int index = md.getIndexId();
        if (type == -1) {
            for (byte i = 0; i < 2; i = (byte)(i + 1)) {
                byte[] valBuf = md.getValueBuffer(i);
                assert (valBuf != null);
                update.addUpdate(index, index == 3 ? BabuDBStorageHelper.createFileIdIndexKey(metadata.getId(), i) : md.getKeyBuffer(i), valBuf);
            }
        } else {
            byte[] valBuf = md.getValueBuffer(type);
            assert (valBuf != null);
            update.addUpdate(index, index == 3 ? BabuDBStorageHelper.createFileIdIndexKey(metadata.getId(), type) : md.getKeyBuffer(type), valBuf);
        }
    }

    @Override
    public void setXAttr(long fileId, String uid, String key, byte[] value, AtomicDBUpdate update) throws DatabaseException {
        this.setXAttr(fileId, uid, key, value, false, update);
    }

    public void setXAttr(long fileId, String uid, String key, byte[] value, boolean init, AtomicDBUpdate update) throws DatabaseException {
        try {
            short collNumber = init ? (short)-1 : (short)BabuDBStorageHelper.findXAttrCollisionNumber(this.database, fileId, uid, key);
            BufferBackedXAttr xattr = new BufferBackedXAttr(fileId, uid, key, value, collNumber);
            update.addUpdate(1, xattr.getKeyBuf(), value == null ? null : xattr.getValBuf());
            if (key.startsWith("xtreemfs.policies")) {
                this.notifyAttributeSet(this.volume.getId(), key, value == null ? null : new String(value));
            }
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public void createSnapshot(String snapName, long parentId, String dirName, boolean recursive) throws DatabaseException {
        try {
            Object prefixes = null;
            FileMetadata snapDir = this.getMetadata(parentId, dirName);
            if (snapDir.getId() != 1L || !recursive) {
                LinkedList<FileMetadata> nestedFiles = new LinkedList<FileMetadata>();
                BabuDBStorageHelper.getNestedFiles(nestedFiles, this.database, snapDir.getId(), recursive);
                ArrayList<byte[]> dirEntryPrefixes = new ArrayList<byte[]>(nestedFiles.size());
                ArrayList<byte[]> filePrefixes = new ArrayList<byte[]>(nestedFiles.size());
                if (snapDir.getId() != 1L) {
                    filePrefixes.add(ByteBuffer.wrap(new byte[8]).putLong(1L).array());
                }
                byte[] idxKey = BabuDBStorageHelper.createFileKey(parentId, dirName, (byte)-1);
                byte[] fileKey = BabuDBStorageHelper.createFilePrefixKey(snapDir.getId());
                dirEntryPrefixes.add(idxKey);
                filePrefixes.add(fileKey);
                idxKey = BabuDBStorageHelper.createFilePrefixKey(snapDir.getId());
                dirEntryPrefixes.add(idxKey);
                for (FileMetadata file : nestedFiles) {
                    byte[] key = BabuDBStorageHelper.createFilePrefixKey(file.getId());
                    if (file.isDirectory()) {
                        filePrefixes.add(key);
                        dirEntryPrefixes.add(key);
                        continue;
                    }
                    filePrefixes.add(key);
                }
                byte[][] dirEntryPrefixesA = (byte[][])dirEntryPrefixes.toArray((T[])new byte[dirEntryPrefixes.size()][]);
                byte[][] filePrefixesA = (byte[][])filePrefixes.toArray((T[])new byte[filePrefixes.size()][]);
                Arrays.sort(dirEntryPrefixesA, DefaultByteRangeComparator.getInstance());
                Arrays.sort(filePrefixesA, DefaultByteRangeComparator.getInstance());
                prefixes = new byte[][][]{dirEntryPrefixesA, filePrefixesA, filePrefixesA, filePrefixesA, (byte[][])null};
            }
            DefaultSnapshotConfig snap = new DefaultSnapshotConfig(snapName, ALL_INDICES, prefixes, (byte[][][])null);
            this.snapMan.createPersistentSnapshot(this.database.getName(), (SnapshotConfig)snap);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public void deleteSnapshot(String snapName) throws DatabaseException {
        try {
            this.snapMan.getSnapshotDB(this.database.getName(), snapName);
            this.snapMan.deletePersistentSnapshot(this.database.getName(), snapName);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public String[] getAllSnapshots() {
        return this.snapMan.getAllSnapshots(this.volume.getId());
    }

    public void dump() throws BabuDBException {
        Map.Entry next;
        System.out.println("FILE_ID_INDEX");
        ResultSet it = (ResultSet)this.database.prefixLookup(3, new byte[0], null).get();
        while (it.hasNext()) {
            next = (Map.Entry)it.next();
            System.out.println(Arrays.toString((byte[])next.getKey()) + " = " + Arrays.toString((byte[])next.getValue()));
        }
        it.free();
        System.out.println("\nFILE_INDEX");
        it = (ResultSet)this.database.prefixLookup(0, new byte[0], null).get();
        while (it.hasNext()) {
            next = (Map.Entry)it.next();
            System.out.println(Arrays.toString((byte[])next.getKey()) + " = " + Arrays.toString((byte[])next.getValue()));
        }
        it.free();
    }

    @Override
    public void dumpDB(BufferedWriter xmlWriter) throws DatabaseException, IOException {
        DBAdminHelper.dumpVolume(xmlWriter, this);
    }

    protected void updateVolumeSize(long diff, AtomicDBUpdate update) throws DatabaseException {
        long newSize = this.getVolumeSize() + diff;
        byte[] sizeBytes = new byte[8];
        ByteBuffer.wrap(sizeBytes).putLong(0, newSize);
        update.addUpdate(4, VOL_SIZE_KEY, sizeBytes);
    }

    protected long getVolumeSize() throws DatabaseException {
        try {
            byte[] sizeBytes = BabuDBStorageHelper.getVolumeMetadata((DatabaseRO)this.database, VOL_SIZE_KEY);
            return ByteBuffer.wrap(sizeBytes).getLong(0);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    protected long getNumFiles() throws DatabaseException {
        try {
            byte[] sizeBytes = BabuDBStorageHelper.getVolumeMetadata((DatabaseRO)this.database, NUM_FILES_KEY);
            return ByteBuffer.wrap(sizeBytes).getLong(0);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    protected long getNumDirs() throws DatabaseException {
        try {
            byte[] sizeBytes = BabuDBStorageHelper.getVolumeMetadata((DatabaseRO)this.database, NUM_DIRS_KEY);
            return ByteBuffer.wrap(sizeBytes).getLong(0);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    protected void notifyVolumeChange(VolumeInfo vol) {
        for (VolumeChangeListener listener : this.vcListeners) {
            listener.volumeChanged(vol);
        }
    }

    protected void notifyVolumeDelete(String volId) {
        for (VolumeChangeListener listener : this.vcListeners) {
            listener.volumeDeleted(volId);
        }
    }

    protected void notifyAttributeSet(String volId, String key, String value) {
        for (VolumeChangeListener listener : this.vcListeners) {
            listener.attributeSet(volId, key, value);
        }
    }

    private void updateCount(byte[] key, boolean increment, AtomicDBUpdate update) throws DatabaseException {
        try {
            byte[] countBytes = BabuDBStorageHelper.getVolumeMetadata((DatabaseRO)this.database, key);
            ByteBuffer countBuf = ByteBuffer.wrap(countBytes);
            countBuf.putLong(0, countBuf.getLong() + (long)(increment ? 1 : -1));
            update.addUpdate(4, key, countBytes);
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    private void initCount(byte[] key, AtomicDBUpdate update) {
        byte[] countBytes = new byte[8];
        ByteBuffer countBuf = ByteBuffer.wrap(countBytes);
        countBuf.putLong(0, 1L);
        update.addUpdate(4, key, countBytes);
    }
}

