/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.database.babudb;

import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.babudb.BabuDBStorageManager;
import org.xtreemfs.mrc.utils.Converter;

public class BabuDBVolumeInfo
implements VolumeInfo {
    private BabuDBStorageManager sMan;
    private String id;
    private String name;
    private short[] osdPolicy;
    private short[] replicaPolicy;
    private short acPolicy;
    private boolean allowSnaps;
    private long quota;

    public void init(BabuDBStorageManager sMan, String id, String name, short[] osdPolicy, short[] replicaPolicy, short acPolicy, boolean allowSnaps, long quota, AtomicDBUpdate update) throws DatabaseException {
        this.sMan = sMan;
        this.id = id;
        this.name = name;
        this.osdPolicy = osdPolicy;
        this.replicaPolicy = replicaPolicy;
        this.acPolicy = acPolicy;
        this.allowSnaps = allowSnaps;
        this.quota = quota;
        sMan.setXAttr(1L, "", "volId", id.getBytes(), true, update);
        sMan.setXAttr(1L, "", "osdPol", Converter.shortArrayToString(osdPolicy).getBytes(), true, update);
        sMan.setXAttr(1L, "", "replPol", Converter.shortArrayToString(replicaPolicy).getBytes(), true, update);
        sMan.setXAttr(1L, "", "acPol", String.valueOf(acPolicy).getBytes(), true, update);
        sMan.setXAttr(1L, "", "allowSnaps", String.valueOf(allowSnaps).getBytes(), true, update);
        sMan.setXAttr(1L, "", "quota", String.valueOf(quota).getBytes(), true, update);
    }

    public void init(BabuDBStorageManager sMan) throws DatabaseException {
        this.sMan = sMan;
        try {
            byte[] idAttr = sMan.getXAttr(1L, "", "volId");
            byte[] acPolicyAttr = sMan.getXAttr(1L, "", "acPol");
            byte[] allowSnapsAttr = sMan.getXAttr(1L, "", "allowSnaps");
            byte[] osdPolicyAttr = sMan.getXAttr(1L, "", "osdPol");
            byte[] replicaPolicyAttr = sMan.getXAttr(1L, "", "replPol");
            byte[] quotaAttr = sMan.getXAttr(1L, "", "quota");
            if (idAttr == null) {
                throw new DatabaseException("database corrupted: volume parameter 'id' not found", DatabaseException.ExceptionType.INTERNAL_DB_ERROR);
            }
            this.id = new String(idAttr);
            this.name = sMan.getMetadata(1L).getFileName();
            if (osdPolicyAttr == null) {
                throw new DatabaseException("database corrupted: volume parameter 'osdPolicy' not found", DatabaseException.ExceptionType.INTERNAL_DB_ERROR);
            }
            this.osdPolicy = Converter.stringToShortArray(new String(osdPolicyAttr));
            if (replicaPolicyAttr == null) {
                throw new DatabaseException("database corrupted: volume parameter 'replicaPolicy' not found", DatabaseException.ExceptionType.INTERNAL_DB_ERROR);
            }
            this.replicaPolicy = Converter.stringToShortArray(new String(replicaPolicyAttr));
            if (acPolicyAttr == null) {
                throw new DatabaseException("database corrupted: volume parameter 'acPolicy' not found", DatabaseException.ExceptionType.INTERNAL_DB_ERROR);
            }
            this.acPolicy = Short.parseShort(new String(acPolicyAttr));
            if (allowSnapsAttr != null) {
                this.allowSnaps = "true".equalsIgnoreCase(new String(allowSnapsAttr));
            }
            if (quotaAttr != null) {
                this.quota = Long.valueOf(new String(quotaAttr));
            }
        }
        catch (NumberFormatException exc) {
            Logging.logError(3, this, exc);
            throw new DatabaseException("corrupted MRC database", DatabaseException.ExceptionType.INTERNAL_DB_ERROR);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short[] getOsdPolicy() {
        return this.osdPolicy;
    }

    @Override
    public short[] getReplicaPolicy() {
        return this.replicaPolicy;
    }

    @Override
    public short getAcPolicyId() {
        return this.acPolicy;
    }

    @Override
    public long getVolumeQuota() throws DatabaseException {
        return this.quota;
    }

    @Override
    public void setOsdPolicy(short[] osdPolicy, AtomicDBUpdate update) throws DatabaseException {
        this.osdPolicy = osdPolicy;
        this.sMan.setXAttr(1L, "", "osdPol", Converter.shortArrayToString(osdPolicy).getBytes(), update);
        this.sMan.notifyVolumeChange(this);
    }

    @Override
    public void setReplicaPolicy(short[] replicaPolicy, AtomicDBUpdate update) throws DatabaseException {
        this.replicaPolicy = replicaPolicy;
        this.sMan.setXAttr(1L, "", "replPol", Converter.shortArrayToString(replicaPolicy).getBytes(), update);
        this.sMan.notifyVolumeChange(this);
    }

    @Override
    public void setAllowSnaps(boolean allowSnaps, AtomicDBUpdate update) throws DatabaseException {
        this.allowSnaps = allowSnaps;
        this.sMan.setXAttr(1L, "", "allowSnaps", String.valueOf(allowSnaps).getBytes(), update);
        this.sMan.notifyVolumeChange(this);
    }

    @Override
    public void setVolumeQuota(long quota, AtomicDBUpdate update) throws DatabaseException {
        this.quota = quota;
        this.sMan.setXAttr(1L, "", "quota", String.valueOf(quota).getBytes(), update);
        this.sMan.notifyVolumeChange(this);
    }

    @Override
    public void updateVolumeSize(long diff, AtomicDBUpdate update) throws DatabaseException {
        this.sMan.updateVolumeSize(diff, update);
    }

    @Override
    public long getNumFiles() throws DatabaseException {
        return this.sMan.getNumFiles();
    }

    @Override
    public long getNumDirs() throws DatabaseException {
        return this.sMan.getNumDirs();
    }

    @Override
    public long getVolumeSize() throws DatabaseException {
        return this.sMan.getVolumeSize();
    }

    @Override
    public boolean isSnapVolume() throws DatabaseException {
        return false;
    }

    @Override
    public boolean isSnapshotsEnabled() throws DatabaseException {
        return this.allowSnaps;
    }

    @Override
    public long getCreationTime() throws DatabaseException {
        return 0L;
    }
}

