/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.database.babudb;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xtreemfs.babudb.BabuDBFactory;
import org.xtreemfs.babudb.api.BabuDB;
import org.xtreemfs.babudb.api.DatabaseManager;
import org.xtreemfs.babudb.api.SnapshotManager;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.transaction.Operation;
import org.xtreemfs.babudb.api.transaction.Transaction;
import org.xtreemfs.babudb.api.transaction.TransactionListener;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.VersionManagement;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.DBAccessResultListener;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeChangeListener;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.database.babudb.BabuDBSnapshotStorageManager;
import org.xtreemfs.mrc.database.babudb.BabuDBStorageManager;
import org.xtreemfs.mrc.metadata.ACLEntry;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class BabuDBVolumeManager
implements VolumeManager {
    private static final String VERSION_DB_NAME = "V";
    private static final String SNAP_VERSIONS_DB_NAME = "snapVers";
    private static final int VERSION_INDEX = 0;
    private static final String VERSION_KEY = "v";
    private BabuDB database;
    private Database snapVersionDB;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private final Map<String, StorageManager> volsById = Collections.synchronizedMap(new HashMap());
    private final Map<String, StorageManager> volsByName = Collections.synchronizedMap(new HashMap());
    private final Collection<VolumeChangeListener> listeners = new LinkedList<VolumeChangeListener>();
    private final BabuDBConfig config;
    private final AtomicBoolean waitLock;

    public BabuDBVolumeManager(MRCRequestDispatcher master, BabuDBConfig dbconfig) {
        this.config = dbconfig;
        this.waitLock = new AtomicBoolean(false);
    }

    @Override
    public void init() throws DatabaseException {
        try {
            this.database = BabuDBFactory.createBabuDB((BabuDBConfig)this.config);
            this.database.getDatabaseManager().addTransactionListener(new TransactionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void transactionPerformed(Transaction txn) {
                    block7: {
                        Operation op = (Operation)txn.getOperations().get(0);
                        if (!(op.getType() != 2 && op.getType() != 4 || BabuDBVolumeManager.VERSION_DB_NAME.equals(op.getDatabaseName()) || BabuDBVolumeManager.SNAP_VERSIONS_DB_NAME.equals(op.getDatabaseName()))) {
                            try {
                                if (op.getType() == 2) {
                                    BabuDBVolumeManager.this.registerVolume(op.getDatabaseName());
                                    AtomicBoolean atomicBoolean = BabuDBVolumeManager.this.waitLock;
                                    synchronized (atomicBoolean) {
                                        BabuDBVolumeManager.this.waitLock.set(true);
                                        BabuDBVolumeManager.this.waitLock.notify();
                                        break block7;
                                    }
                                }
                                BabuDBVolumeManager.this.deregisterVolume(op.getDatabaseName());
                            }
                            catch (Exception exc) {
                                Logging.logError(3, this, exc);
                            }
                        }
                    }
                }
            });
            this.initDB(this.database.getDatabaseManager(), this.database.getSnapshotManager());
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.database.shutdown();
        }
        catch (BabuDBException exc) {
            Logging.logMessage(4, Logging.Category.lifecycle, this, "could not shut down volume manager", new Object[0]);
            Logging.logError(4, this, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createVolume(FileAccessManager faMan, String volumeId, String volumeName, short fileAccessPolicyId, String ownerId, String owningGroupId, GlobalTypes.StripingPolicy defaultStripingPolicy, int initialAccessMode, long volumeQuota, List<GlobalTypes.KeyValuePair> attrs) throws UserException, DatabaseException {
        this.waitLock.set(false);
        if (volumeName.indexOf(64) != -1 || volumeName.indexOf(47) != -1 || volumeName.indexOf(92) != -1) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "volume name must not contain '@', '/' or '\\'");
        }
        if (this.hasVolume(volumeName)) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EEXIST, "volume ' " + volumeName + "' already exists locally");
        }
        ACLEntry[] acl = faMan.getFileAccessPolicy(fileAccessPolicyId).getDefaultRootACL();
        new BabuDBStorageManager(this.database, volumeId, volumeName, fileAccessPolicyId, DEFAULT_OSD_POLICY, DEFAULT_REPL_POLICY, ownerId, owningGroupId, initialAccessMode, acl, defaultStripingPolicy, false, volumeQuota, KeyValuePairs.toMap(attrs));
        AtomicBoolean atomicBoolean = this.waitLock;
        synchronized (atomicBoolean) {
            while (!this.waitLock.get()) {
                try {
                    this.waitLock.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Override
    public boolean hasVolume(String volumeName) throws DatabaseException {
        return this.volsByName.containsKey(volumeName);
    }

    @Override
    public boolean hasVolumeWithId(String volumeId) throws DatabaseException {
        return this.volsById.containsKey(volumeId);
    }

    @Override
    public void deleteVolume(String volumeId, DBAccessResultListener<Object> listener, Object context) throws DatabaseException, UserException {
        StorageManager sMan = this.getStorageManager(volumeId);
        this.volsById.remove(volumeId);
        this.volsByName.remove(sMan.getVolumeInfo().getName());
        sMan.deleteDatabase();
    }

    @Override
    public StorageManager getStorageManager(String volumeId) throws UserException {
        StorageManager sMan = this.volsById.get(volumeId);
        if (sMan == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "volume '" + volumeId + "' not found on this MRC");
        }
        return sMan;
    }

    @Override
    public StorageManager getStorageManagerByName(String volumeName) throws UserException {
        StorageManager sMan = this.volsByName.get(volumeName);
        if (sMan == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "volume '" + volumeName + "' not found on this MRC");
        }
        return sMan;
    }

    @Override
    public void checkpointDB() throws DatabaseException {
        try {
            this.database.getCheckpointer().checkpoint();
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    @Override
    public String newVolumeId() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<StorageManager> getStorageManagers() {
        if (!this.initialized.get()) {
            return null;
        }
        HashSet<StorageManager> result = new HashSet<StorageManager>();
        Collection<StorageManager> sMans = this.volsById.values();
        Map<String, StorageManager> map = this.volsById;
        synchronized (map) {
            for (StorageManager sMan : sMans) {
                result.add(sMan);
            }
        }
        return result;
    }

    @Override
    public void addVolumeChangeListener(VolumeChangeListener listener) {
        this.listeners.add(listener);
        for (StorageManager sMan : this.volsById.values()) {
            sMan.addVolumeChangeListener(listener);
        }
    }

    @Override
    public void createSnapshot(String volumeId, String snapName, long parentId, FileMetadata dir, boolean recursive) throws UserException, DatabaseException {
        try {
            StorageManager sMan = this.getStorageManager(volumeId);
            if (!snapName.equals(".dump") && !sMan.getVolumeInfo().isSnapshotsEnabled()) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "snapshot operations are not allowed on this volume");
            }
            long currentTime = TimeSync.getGlobalTime();
            byte[] currentTimeAndParentAsBytes = ByteBuffer.wrap(new byte[16]).putLong(currentTime).putLong(parentId).array();
            if ("".equals(snapName)) {
                snapName = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date(currentTime)) + "";
            }
            String snapVolName = sMan.getVolumeInfo().getName() + '@' + snapName;
            try {
                this.snapVersionDB.singleInsert(0, snapVolName.getBytes(), currentTimeAndParentAsBytes, null).get();
            }
            catch (BabuDBException exc2) {
                throw new DatabaseException(exc2);
            }
            sMan.createSnapshot(snapName, parentId, dir.getFileName(), recursive);
            this.volsByName.put(snapVolName, new BabuDBSnapshotStorageManager(this.database.getSnapshotManager(), sMan.getVolumeInfo().getName(), volumeId, snapName, currentTime, parentId));
        }
        catch (DatabaseException exc) {
            if (((BabuDBException)exc.getCause()).getErrorCode() == BabuDBException.ErrorCode.SNAP_EXISTS) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, exc.getMessage());
            }
            throw exc;
        }
    }

    @Override
    public void deleteSnapshot(String volumeId, FileMetadata dir, String snapName) throws UserException, DatabaseException {
        try {
            StorageManager sMan = this.getStorageManager(volumeId);
            String snapVolName = sMan.getVolumeInfo().getName() + '@' + snapName;
            this.volsByName.remove(snapVolName);
            sMan.deleteSnapshot(snapName);
            try {
                this.snapVersionDB.singleInsert(0, snapVolName.getBytes(), null, null).get();
            }
            catch (BabuDBException exc) {
                throw new DatabaseException(exc);
            }
        }
        catch (DatabaseException exc) {
            if (((BabuDBException)exc.getCause()).getErrorCode() == BabuDBException.ErrorCode.NO_SUCH_SNAPSHOT) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENODEV, exc.getMessage());
            }
            throw exc;
        }
    }

    @Override
    public Collection<Long> getSnapTimestamps(String volName) throws UserException, DatabaseException {
        try {
            LinkedList<Long> result = new LinkedList<Long>();
            byte[] prefix = (volName + '@').getBytes();
            ResultSet it = null;
            try {
                it = (ResultSet)this.snapVersionDB.prefixLookup(0, prefix, null).get();
                while (it.hasNext()) {
                    byte[] bytes = (byte[])((Map.Entry)it.next()).getValue();
                    long ts = ByteBuffer.wrap(bytes).getLong();
                    result.add(ts);
                }
            }
            catch (BabuDBException exc) {
                throw new DatabaseException(exc);
            }
            finally {
                if (it != null) {
                    it.free();
                }
            }
            return result;
        }
        catch (DatabaseException exc) {
            if (((BabuDBException)exc.getCause()).getErrorCode() == BabuDBException.ErrorCode.SNAP_EXISTS) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, exc.getMessage());
            }
            throw exc;
        }
    }

    @Override
    public String getDBVersion() {
        return "0.5.6";
    }

    @Override
    public Map<String, Object> getDBStatus() {
        return this.database == null ? null : this.database.getRuntimeState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDB(DatabaseManager dbMan, SnapshotManager snapMan) throws DatabaseException {
        block20: {
            if (this.snapVersionDB == null) {
                try {
                    this.snapVersionDB = dbMan.createDatabase(SNAP_VERSIONS_DB_NAME, 1);
                }
                catch (BabuDBException exc) {
                    if (exc.getErrorCode() == BabuDBException.ErrorCode.DB_EXISTS) {
                        try {
                            this.snapVersionDB = dbMan.getDatabase(SNAP_VERSIONS_DB_NAME);
                        }
                        catch (BabuDBException exc2) {
                            throw new DatabaseException(exc2);
                        }
                    }
                    throw new DatabaseException(exc);
                }
            }
            assert (this.snapVersionDB != null);
            try {
                Transaction txn = dbMan.createTransaction();
                txn.createDatabase(VERSION_DB_NAME, 3);
                byte[] verBytes = ByteBuffer.wrap(new byte[4]).putInt((int)VersionManagement.getMrcDataVersion()).array();
                txn.insertRecord(VERSION_DB_NAME, 0, VERSION_KEY.getBytes(), verBytes);
                dbMan.executeTransaction(txn);
            }
            catch (BabuDBException e) {
                if (e.getErrorCode() == BabuDBException.ErrorCode.DB_EXISTS) {
                    Database verDB = null;
                    try {
                        verDB = dbMan.getDatabase(VERSION_DB_NAME);
                    }
                    catch (BabuDBException e1) {
                        throw new DatabaseException(e1);
                    }
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.storage, this, "database loaded from '%s'", this.config.getBaseDir());
                    }
                    try {
                        byte[] verBytes = (byte[])verDB.lookup(0, VERSION_KEY.getBytes(), null).get();
                        int ver = ByteBuffer.wrap(verBytes).getInt();
                        if ((long)ver != VersionManagement.getMrcDataVersion()) {
                            String errMsg = "Wrong database version. Expected version = " + VersionManagement.getMrcDataVersion() + ", version on disk = " + ver;
                            Logging.logMessage(2, this, errMsg, new Object[0]);
                            if (VersionManagement.getMrcDataVersion() > (long)ver) {
                                Logging.logMessage(2, this, "Please create an XML dump with the old MRC version and restore the dump with this MRC, or delete the database if the file system is no longer needed.", new Object[0]);
                            }
                            throw new DatabaseException(errMsg, DatabaseException.ExceptionType.WRONG_DB_VERSION);
                        }
                    }
                    catch (Exception exc) {
                        Logging.logMessage(2, this, "The MRC database is either corrupted or outdated. The expected database version for this server is " + VersionManagement.getMrcDataVersion(), new Object[0]);
                        throw new DatabaseException(exc);
                    }
                    this.initVolumes(dbMan, snapMan);
                    break block20;
                }
                throw new DatabaseException(e);
            }
            finally {
                this.initialized.set(true);
            }
        }
    }

    private void initVolumes(DatabaseManager dbMan, SnapshotManager snapMan) throws DatabaseException {
        for (Map.Entry dbEntry : dbMan.getDatabases().entrySet()) {
            if (((String)dbEntry.getKey()).equals(VERSION_DB_NAME) || ((String)dbEntry.getKey()).equals(SNAP_VERSIONS_DB_NAME)) continue;
            BabuDBStorageManager sMan = new BabuDBStorageManager(dbMan, snapMan, (Database)dbEntry.getValue());
            VolumeInfo vol = sMan.getVolumeInfo();
            this.volsById.put(vol.getId(), sMan);
            this.volsByName.put(vol.getName(), sMan);
            for (String snapName : sMan.getAllSnapshots()) {
                if (snapName.equals(".dump")) continue;
                String snapVolName = vol.getName() + '@' + snapName;
                try {
                    byte[] timeStampAndParentBytes = (byte[])this.snapVersionDB.lookup(0, snapVolName.getBytes(), null).get();
                    if (timeStampAndParentBytes == null) {
                        Logging.logMessage(4, Logging.Category.storage, this, "no version mapping exists for snapshot %s; file contents may be corrupted", snapVolName);
                    }
                    long snapTime = timeStampAndParentBytes == null ? 0L : ByteBuffer.wrap(timeStampAndParentBytes).getLong();
                    long parentId = timeStampAndParentBytes == null ? 0L : ByteBuffer.wrap(timeStampAndParentBytes).getLong(8);
                    this.volsByName.put(snapVolName, new BabuDBSnapshotStorageManager(snapMan, vol.getName(), vol.getId(), snapName, snapTime, parentId));
                }
                catch (BabuDBException exc) {
                    throw new DatabaseException(exc);
                }
            }
            for (VolumeChangeListener l : this.listeners) {
                sMan.addVolumeChangeListener(l);
            }
        }
    }

    private void registerVolume(String volumeId) throws DatabaseException {
        DatabaseManager dbMan = this.database.getDatabaseManager();
        try {
            BabuDBStorageManager sMan = new BabuDBStorageManager(dbMan, this.database.getSnapshotManager(), dbMan.getDatabase(volumeId));
            VolumeInfo vol = sMan.getVolumeInfo();
            this.volsById.put(vol.getId(), sMan);
            this.volsByName.put(vol.getName(), sMan);
            for (VolumeChangeListener l : this.listeners) {
                sMan.addVolumeChangeListener(l);
            }
        }
        catch (BabuDBException exc) {
            throw new DatabaseException(exc);
        }
    }

    private void deregisterVolume(String volumeId) {
        StorageManager sMan = this.volsById.remove(volumeId);
        if (sMan != null) {
            this.volsByName.remove(sMan.getVolumeInfo().getName());
        }
    }
}

