/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.database.babudb;

import java.net.InetSocketAddress;
import java.util.StringTokenizer;
import org.xtreemfs.babudb.api.DatabaseManager;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.transaction.Transaction;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;

public class TransactionalBabuDBUpdate
implements AtomicDBUpdate {
    private final DatabaseManager dbMan;
    private final Transaction txn;
    private String databaseName;

    public TransactionalBabuDBUpdate(DatabaseManager dbMan) {
        this.dbMan = dbMan;
        this.txn = dbMan.createTransaction();
    }

    public void createDatabase(String databaseName, int numIndices) {
        this.databaseName = databaseName;
        this.txn.createDatabase(databaseName, numIndices);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void addUpdate(Object ... update) {
        assert (this.databaseName != null);
        this.txn.insertRecord(this.databaseName, ((Integer)update[0]).intValue(), (byte[])update[1], (byte[])update[2]);
    }

    @Override
    public void execute() throws DatabaseException {
        try {
            this.dbMan.executeTransaction(this.txn);
        }
        catch (BabuDBException exc) {
            if (exc.getErrorCode() == BabuDBException.ErrorCode.REDIRECT) {
                StringTokenizer st = new StringTokenizer(exc.getMessage(), ": ");
                InetSocketAddress target = new InetSocketAddress(st.nextToken(), Integer.parseInt(st.nextToken()));
                throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT, target);
            }
            throw new DatabaseException(exc);
        }
        catch (Exception exc) {
            throw new DatabaseException(exc);
        }
    }

    public String toString() {
        return this.txn.toString();
    }
}

