/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.metadata;

import java.nio.ByteBuffer;
import org.xtreemfs.mrc.metadata.ACLEntry;
import org.xtreemfs.mrc.metadata.BufferBackedIndexMetadata;

public class BufferBackedACLEntry
extends BufferBackedIndexMetadata
implements ACLEntry {
    private String entity;
    private short rights;

    public BufferBackedACLEntry(byte[] key, byte[] val) {
        super(key, 0, key.length, val, 0, val.length);
        ByteBuffer tmp = ByteBuffer.wrap(val);
        this.entity = new String(key, 8, key.length - 8);
        this.rights = tmp.getShort(0);
    }

    public BufferBackedACLEntry(long fileId, String entity, short rights) {
        super(null, 0, 0, null, 0, 0);
        this.keyLen = 8 + entity.getBytes().length;
        this.keyBuf = new byte[this.keyLen];
        ByteBuffer tmp = ByteBuffer.wrap(this.keyBuf);
        tmp.putLong(fileId);
        tmp.put(entity.getBytes());
        this.valLen = 2;
        this.valBuf = new byte[this.valLen];
        tmp = ByteBuffer.wrap(this.valBuf);
        tmp.putShort(rights);
        this.entity = entity;
        this.rights = rights;
    }

    @Override
    public String getEntity() {
        return this.entity;
    }

    @Override
    public short getRights() {
        return this.rights;
    }
}

