/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.metadata;

import java.nio.ByteBuffer;
import org.xtreemfs.mrc.metadata.BufferBackedRCMetadata;
import org.xtreemfs.mrc.metadata.BufferBackedXLocList;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.XLocList;

public class BufferBackedFileMetadata
implements FileMetadata {
    public static final short NUM_BUFFERS = 2;
    protected static final int FC_ATIME = 0;
    protected static final int FC_CTIME = 4;
    protected static final int FC_MTIME = 8;
    protected static final int FC_SIZE = 12;
    private final ByteBuffer fcKeyBuf;
    private final ByteBuffer fcValBuf;
    private BufferBackedRCMetadata rcMetadata;
    private int indexId;

    public BufferBackedFileMetadata(byte[][] keyBufs, byte[][] valBufs, int indexId) {
        assert (keyBufs.length == 2);
        assert (valBufs.length == 2);
        byte[][] keyBufsCopy = new byte[keyBufs.length][];
        byte[][] valBufsCopy = new byte[valBufs.length][];
        for (int i = 0; i < keyBufs.length; ++i) {
            keyBufsCopy[i] = keyBufs[i] == null ? null : new byte[keyBufs[i].length];
            valBufsCopy[i] = new byte[valBufs[i].length];
            if (keyBufsCopy[i] != null) {
                System.arraycopy(keyBufs[i], 0, keyBufsCopy[i], 0, keyBufs[i].length);
            }
            System.arraycopy(valBufs[i], 0, valBufsCopy[i], 0, valBufs[i].length);
        }
        this.fcKeyBuf = keyBufsCopy[0] == null ? null : ByteBuffer.wrap(keyBufsCopy[0]);
        this.fcValBuf = ByteBuffer.wrap(valBufsCopy[0]);
        this.rcMetadata = new BufferBackedRCMetadata(keyBufsCopy[1], valBufsCopy[1]);
        this.indexId = indexId;
    }

    public BufferBackedFileMetadata(long parentId, String fileName, String ownerId, String groupId, long fileId, int atime, int ctime, int mtime, long size, int perms, long w32Atrrs, short linkCount, int epoch, int issEpoch, boolean readOnly) {
        this.fcKeyBuf = BufferBackedFileMetadata.generateKeyBuf(parentId, fileName, 0);
        this.fcValBuf = ByteBuffer.wrap(new byte[20]).putInt(atime).putInt(ctime).putInt(mtime).putLong(size);
        this.rcMetadata = new BufferBackedRCMetadata(parentId, fileName, ownerId, groupId, fileId, perms, w32Atrrs, linkCount, epoch, issEpoch, readOnly);
    }

    public BufferBackedFileMetadata(long parentId, String dirName, String ownerId, String groupId, long fileId, int atime, int ctime, int mtime, int perms, long w32Attrs, short linkCount) {
        this.fcKeyBuf = BufferBackedFileMetadata.generateKeyBuf(parentId, dirName, 0);
        this.fcValBuf = ByteBuffer.wrap(new byte[12]).putInt(atime).putInt(ctime).putInt(mtime);
        this.rcMetadata = new BufferBackedRCMetadata(parentId, dirName, ownerId, groupId, fileId, perms, w32Attrs, linkCount);
    }

    @Override
    public long getId() {
        return this.rcMetadata.getId();
    }

    @Override
    public int getAtime() {
        return this.fcValBuf.getInt(0);
    }

    @Override
    public int getCtime() {
        return this.fcValBuf.getInt(4);
    }

    @Override
    public int getMtime() {
        return this.fcValBuf.getInt(8);
    }

    @Override
    public int getEpoch() {
        return this.rcMetadata.getEpoch();
    }

    @Override
    public int getIssuedEpoch() {
        return this.rcMetadata.getIssuedEpoch();
    }

    @Override
    public short getLinkCount() {
        return this.rcMetadata.getLinkCount();
    }

    @Override
    public int getPerms() {
        return this.rcMetadata.getPerms();
    }

    @Override
    public long getSize() {
        return this.fcValBuf.getLong(12);
    }

    @Override
    public boolean isReadOnly() {
        return this.rcMetadata.isReadOnly();
    }

    @Override
    public void setId(long id) {
        this.rcMetadata.setId(id);
    }

    @Override
    public void setAtime(int atime) {
        this.fcValBuf.putInt(0, atime);
    }

    @Override
    public void setCtime(int ctime) {
        this.fcValBuf.putInt(4, ctime);
    }

    @Override
    public void setMtime(int mtime) {
        this.fcValBuf.putInt(8, mtime);
    }

    @Override
    public void setEpoch(int epoch) {
        this.rcMetadata.setEpoch(epoch);
    }

    @Override
    public void setIssuedEpoch(int issuedEpoch) {
        this.rcMetadata.setIssuedEpoch(issuedEpoch);
    }

    @Override
    public void setLinkCount(short linkCount) {
        this.rcMetadata.setLinkCount(linkCount);
    }

    @Override
    public void setPerms(int perms) {
        this.rcMetadata.setPerms(perms);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.rcMetadata.setReadOnly(readOnly);
    }

    @Override
    public void setSize(long size) {
        this.fcValBuf.putLong(12, size);
    }

    @Override
    public void setW32Attrs(long w32Attrs) {
        this.rcMetadata.setW32Attrs(w32Attrs);
    }

    @Override
    public String getFileName() {
        return this.rcMetadata.getFileName();
    }

    @Override
    public String getOwnerId() {
        return this.rcMetadata.getOwnerId();
    }

    @Override
    public String getOwningGroupId() {
        return this.rcMetadata.getOwningGroupId();
    }

    @Override
    public long getW32Attrs() {
        return this.rcMetadata.getW32Attrs();
    }

    @Override
    public XLocList getXLocList() {
        return this.rcMetadata.getXLocList();
    }

    @Override
    public boolean isDirectory() {
        return this.rcMetadata.isDirectory();
    }

    @Override
    public void setXLocList(XLocList xlocList) {
        assert (!this.isDirectory()) : "cannot assign locations list to directory";
        assert (xlocList instanceof BufferBackedXLocList);
        BufferBackedXLocList bbXLocList = (BufferBackedXLocList)xlocList;
        this.rcMetadata.setXLocList(bbXLocList);
    }

    @Override
    public void setOwnerAndGroup(String owner, String group) {
        BufferBackedRCMetadata tmp = this.isDirectory() ? new BufferBackedRCMetadata(0L, this.rcMetadata.getFileName(), owner, group, this.rcMetadata.getId(), this.rcMetadata.getPerms(), this.rcMetadata.getW32Attrs(), this.rcMetadata.getLinkCount()) : new BufferBackedRCMetadata(0L, this.rcMetadata.getFileName(), owner, group, this.rcMetadata.getId(), this.rcMetadata.getPerms(), this.rcMetadata.getW32Attrs(), this.rcMetadata.getLinkCount(), this.rcMetadata.getEpoch(), this.rcMetadata.getIssuedEpoch(), this.rcMetadata.isReadOnly());
        BufferBackedRCMetadata oldRCMetadata = this.rcMetadata;
        this.rcMetadata = new BufferBackedRCMetadata(this.rcMetadata == null ? null : this.rcMetadata.getKey(), tmp.getValue());
        if (!this.rcMetadata.isDirectory()) {
            this.rcMetadata.setXLocList(oldRCMetadata.getXLocList());
        }
    }

    public byte[] getFCMetadataKey() {
        return this.fcKeyBuf == null ? null : this.fcKeyBuf.array();
    }

    public byte[] getFCMetadataValue() {
        return this.fcValBuf.array();
    }

    public BufferBackedRCMetadata getRCMetadata() {
        return this.rcMetadata;
    }

    public byte[] getKeyBuffer(int type) {
        switch (type) {
            case 0: {
                return this.fcKeyBuf.array();
            }
            case 1: {
                return this.rcMetadata.getKey();
            }
        }
        return null;
    }

    public byte[] getValueBuffer(byte type) {
        switch (type) {
            case 0: {
                return this.fcValBuf.array();
            }
            case 1: {
                return this.rcMetadata.getValue();
            }
        }
        return null;
    }

    public int getIndexId() {
        return this.indexId;
    }

    public String toString() {
        String s = (this.isDirectory() ? "dir" : "file") + " id=" + this.getId() + " name=" + this.getFileName() + " mode=" + this.getPerms() + " w32Attrs=" + this.getW32Attrs() + " atime=" + this.getAtime() + " mtime=" + this.getMtime() + " ctime=" + this.getCtime() + " owner=" + this.getOwnerId() + " group=" + this.getOwningGroupId();
        if (!this.isDirectory()) {
            s = s + " size=" + this.getSize() + " epoch=" + this.getEpoch() + " issEpoch=" + this.getIssuedEpoch();
        }
        return s;
    }

    protected static ByteBuffer generateKeyBuf(long parentId, String fileName, int type) {
        byte[] bytes = fileName.getBytes();
        byte[] tmp = new byte[9 + bytes.length];
        ByteBuffer buf = ByteBuffer.wrap(tmp);
        buf.putLong(parentId).put(bytes).put((byte)type);
        return buf;
    }
}

