/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.metadata;

import java.nio.ByteBuffer;
import org.xtreemfs.mrc.metadata.BufferBackedFileMetadata;
import org.xtreemfs.mrc.metadata.BufferBackedXLocList;

public class BufferBackedRCMetadata {
    protected static final int RC_TYPE = 0;
    protected static final int RC_ID = 1;
    protected static final int RC_PERMS = 9;
    protected static final int RC_LINKCOUNT = 13;
    protected static final int RC_W32ATTRS = 15;
    protected static final int RC_EPOCH = 23;
    protected static final int RC_ISSEPOCH = 27;
    protected static final int RC_READONLY = 31;
    protected static final int RC_DIR_GROUP_OFFSET = 23;
    protected static final int DIR_VAR_LEN_PART_OFFSET = 25;
    protected static final int RC_FILE_GROUP_OFFSET = 32;
    protected static final int RC_XLOC_OFFSET = 34;
    protected static final int FILE_VAR_LEN_PART_OFFSET = 36;
    private final short groupOffset;
    private final short xLocOffset;
    private final boolean directory;
    private final ByteBuffer keyBuf;
    private ByteBuffer valBuf;
    private BufferBackedXLocList cachedXLocList;

    public BufferBackedRCMetadata(byte[] keyBuf, byte[] valBuf) {
        this.keyBuf = keyBuf == null ? null : ByteBuffer.wrap(keyBuf);
        this.valBuf = ByteBuffer.wrap(valBuf);
        this.directory = valBuf[0] == 1;
        this.groupOffset = this.valBuf.getShort(this.directory ? 23 : 32);
        this.xLocOffset = this.directory ? (short)valBuf.length : this.valBuf.getShort(34);
    }

    public BufferBackedRCMetadata(long parentId, String fileName, String ownerId, String groupId, long fileId, int perms, long w32Attrs, short linkCount, int epoch, int issEpoch, boolean readOnly) {
        this.keyBuf = BufferBackedFileMetadata.generateKeyBuf(parentId, fileName, 1);
        byte[] oBytes = ownerId.getBytes();
        byte[] gBytes = groupId.getBytes();
        int bufSize = 36 + oBytes.length + gBytes.length;
        this.groupOffset = (short)(bufSize - gBytes.length);
        this.xLocOffset = (short)bufSize;
        this.valBuf = ByteBuffer.wrap(new byte[bufSize]);
        this.valBuf.put((byte)0).putLong(fileId).putInt(perms).putShort(linkCount).putLong(w32Attrs).putInt(epoch).putInt(issEpoch).put((byte)(readOnly ? 1 : 0)).putShort(this.groupOffset).putShort(this.xLocOffset).put(oBytes).put(gBytes);
        this.directory = false;
    }

    public BufferBackedRCMetadata(long parentId, String dirName, String ownerId, String groupId, long fileId, int perms, long w32Attrs, short linkCount) {
        this.keyBuf = BufferBackedFileMetadata.generateKeyBuf(parentId, dirName, 1);
        byte[] oBytes = ownerId.getBytes();
        byte[] gBytes = groupId.getBytes();
        int bufSize = 25 + oBytes.length + gBytes.length;
        this.groupOffset = (short)(bufSize - gBytes.length);
        this.xLocOffset = (short)bufSize;
        this.valBuf = ByteBuffer.wrap(new byte[bufSize]);
        this.valBuf.put((byte)1).putLong(fileId).putInt(perms).putShort(linkCount).putLong(w32Attrs).putShort(this.groupOffset).put(oBytes).put(gBytes);
        this.directory = true;
    }

    public long getId() {
        return this.valBuf.getLong(1);
    }

    public byte getType() {
        return this.valBuf.get();
    }

    public int getEpoch() {
        return this.valBuf.getInt(23);
    }

    public int getIssuedEpoch() {
        return this.valBuf.getInt(27);
    }

    public short getLinkCount() {
        return this.valBuf.getShort(13);
    }

    public int getPerms() {
        return this.valBuf.getInt(9);
    }

    public BufferBackedXLocList getXLocList() {
        if (this.directory) {
            return null;
        }
        if (this.cachedXLocList == null) {
            byte[] bytes = this.valBuf.array();
            short index = this.valBuf.getShort(34);
            assert (bytes.length - index >= 0);
            if (bytes.length - index != 0) {
                this.cachedXLocList = new BufferBackedXLocList(bytes, index, bytes.length - index);
            }
        }
        return this.cachedXLocList;
    }

    public boolean isReadOnly() {
        return this.valBuf.get(31) != 0;
    }

    public void setId(long id) {
        this.valBuf.putLong(1, id);
    }

    public void setEpoch(int epoch) {
        this.valBuf.putInt(23, epoch);
    }

    public void setIssuedEpoch(int issuedEpoch) {
        this.valBuf.putInt(27, issuedEpoch);
    }

    public void setLinkCount(short linkCount) {
        this.valBuf.putShort(13, linkCount);
    }

    public void setPerms(int perms) {
        this.valBuf.putInt(9, perms);
    }

    public void setReadOnly(boolean readOnly) {
        this.valBuf.put(31, (byte)(readOnly ? 1 : 0));
    }

    public void setW32Attrs(long w32Attrs) {
        this.valBuf.putLong(15, w32Attrs);
    }

    public void setXLocList(BufferBackedXLocList xLocList) {
        short offset = this.valBuf.getShort(34);
        byte[] bytes = this.valBuf.array();
        assert (offset <= bytes.length) : "offset=" + offset + ", bufsize=" + bytes.length;
        byte[] xLocBytes = xLocList == null ? new byte[]{} : xLocList.getBuffer();
        int xLocOffs = xLocList == null ? 0 : xLocList.getOffset();
        int xLocLen = xLocList == null ? 0 : xLocList.getLength();
        byte[] tmp = new byte[offset + xLocLen];
        System.arraycopy(bytes, 0, tmp, 0, offset);
        System.arraycopy(xLocBytes, xLocOffs, tmp, offset, xLocLen);
        this.valBuf = ByteBuffer.wrap(tmp);
        this.cachedXLocList = xLocList;
    }

    public String getFileName() {
        byte[] bytes = this.keyBuf.array();
        return new String(bytes, 8, bytes.length - 9);
    }

    public String getOwnerId() {
        int index = this.directory ? 25 : 36;
        int length = this.groupOffset - index;
        return new String(this.valBuf.array(), index, length);
    }

    public String getOwningGroupId() {
        short startIndex = this.groupOffset;
        int endIndex = this.directory ? this.valBuf.limit() : this.xLocOffset;
        int length = endIndex - startIndex;
        return new String(this.valBuf.array(), (int)startIndex, length);
    }

    public long getW32Attrs() {
        return this.valBuf.getLong(15);
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public byte[] getKey() {
        return this.keyBuf == null ? null : this.keyBuf.array();
    }

    public byte[] getValue() {
        return this.valBuf.array();
    }
}

