/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.metadata;

import java.nio.ByteBuffer;
import org.xtreemfs.mrc.metadata.BufferBackedMetadata;
import org.xtreemfs.mrc.metadata.StripingPolicy;

public class BufferBackedStripingPolicy
extends BufferBackedMetadata
implements StripingPolicy {
    private static final int SIZE_INDEX = 0;
    private static final int WIDTH_INDEX = 4;
    private static final int PATTERN_INDEX = 8;
    private String pattern;
    private int stripeSize;
    private int width;

    public BufferBackedStripingPolicy(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public BufferBackedStripingPolicy(byte[] buffer, int offset, int len) {
        super(buffer, offset, len);
        this.pattern = new String(buffer, offset + 8, len - 8);
        ByteBuffer tmp = ByteBuffer.wrap(buffer, offset + 0, 4);
        this.stripeSize = tmp.getInt();
        tmp = ByteBuffer.wrap(buffer, offset + 4, 4);
        this.width = tmp.getInt();
    }

    public BufferBackedStripingPolicy(String pattern, int stripeSize, int width) {
        super(null, 0, 0);
        this.len = pattern.getBytes().length + 8;
        this.buffer = new byte[this.len];
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer);
        tmp.putInt(stripeSize).putInt(width).put(pattern.getBytes());
        this.pattern = pattern;
        this.stripeSize = stripeSize;
        this.width = width;
    }

    public boolean equals(StripingPolicy pol) {
        return this.toString().equals(pol.toString());
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public int getStripeSize() {
        return this.stripeSize;
    }

    @Override
    public int getWidth() {
        return this.width;
    }
}

