/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.metadata;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.xtreemfs.mrc.metadata.BufferBackedIndexMetadata;
import org.xtreemfs.mrc.metadata.XAttr;

public class BufferBackedXAttr
extends BufferBackedIndexMetadata
implements XAttr {
    private final short ownerOffset;
    private final short keyOffset;
    private final short valOffset;

    public BufferBackedXAttr(byte[] key, byte[] val) {
        super(key, 0, key.length, val, 0, val.length);
        ByteBuffer tmp = ByteBuffer.wrap(val);
        this.ownerOffset = (short)4;
        this.keyOffset = tmp.getShort();
        this.valOffset = tmp.getShort();
    }

    public BufferBackedXAttr(long fileId, String owner, String key, byte[] value, short collCount) {
        super(null, 0, 0, null, 0, 0);
        byte[] ownerBytes = owner.getBytes();
        byte[] keyBytes = key.getBytes();
        byte[] valBytes = value == null ? new byte[]{} : value;
        this.keyLen = 18;
        this.keyBuf = new byte[this.keyLen];
        ByteBuffer tmp = ByteBuffer.wrap(this.keyBuf);
        tmp.putLong(fileId).putInt(owner.hashCode()).putInt(key.hashCode()).putShort(collCount);
        this.ownerOffset = (short)4;
        this.keyOffset = (short)(4 + ownerBytes.length);
        this.valOffset = (short)(4 + ownerBytes.length + keyBytes.length);
        this.valLen = 4 + ownerBytes.length + keyBytes.length + valBytes.length;
        this.valBuf = new byte[this.valLen];
        tmp = ByteBuffer.wrap(this.valBuf).putShort(this.keyOffset).putShort(this.valOffset).put(ownerBytes).put(keyBytes).put(valBytes);
    }

    @Override
    public String getKey() {
        return new String(this.valBuf, (int)this.keyOffset, this.valOffset - this.keyOffset);
    }

    @Override
    public String getOwner() {
        return new String(this.valBuf, (int)this.ownerOffset, this.keyOffset - this.ownerOffset);
    }

    @Override
    public byte[] getValue() {
        return Arrays.copyOfRange(this.valBuf, (int)this.valOffset, this.valBuf.length);
    }

    public void setCollisionNumber(short collisionNumber) {
        ByteBuffer tmp = ByteBuffer.wrap(this.keyBuf);
        tmp.putShort(16, collisionNumber);
    }

    @Override
    public String toString() {
        return "(" + this.getKey() + " = " + this.getValue() + " [" + this.getOwner() + "])";
    }
}

