/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.metadata;

import java.nio.ByteBuffer;
import org.xtreemfs.mrc.metadata.BufferBackedMetadata;
import org.xtreemfs.mrc.metadata.BufferBackedStripingPolicy;
import org.xtreemfs.mrc.metadata.StripingPolicy;
import org.xtreemfs.mrc.metadata.XLoc;

public class BufferBackedXLoc
extends BufferBackedMetadata
implements XLoc {
    private String[] osdCache;
    private StripingPolicy stripingPolicy;

    public BufferBackedXLoc(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public BufferBackedXLoc(byte[] buffer, int offset, int len) {
        super(buffer, offset, len);
        ByteBuffer tmp = ByteBuffer.wrap(buffer, offset, len);
        short numOSDs = tmp.getShort(offset + tmp.getShort(offset));
        this.osdCache = new String[numOSDs];
    }

    public BufferBackedXLoc(BufferBackedStripingPolicy stripingPolicy, String[] osds, int replFlags) {
        super(null, 0, 0);
        int bufSize;
        assert (osds.length <= Short.MAX_VALUE);
        this.osdCache = new String[osds.length];
        int osdListSize = 2;
        for (String osd : osds) {
            osdListSize += osd.getBytes().length + 2;
        }
        int spolSize = stripingPolicy.getLength();
        assert (spolSize <= Short.MAX_VALUE);
        this.len = bufSize = spolSize + osdListSize + 6;
        this.buffer = new byte[this.len];
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer);
        tmp.putShort((short)(spolSize + 6));
        tmp.putInt(replFlags);
        tmp.put(stripingPolicy.getBuffer(), stripingPolicy.getOffset(), stripingPolicy.getLength());
        tmp.putShort((short)osds.length);
        byte[][] osdBytes = new byte[osds.length][];
        int ofs0 = tmp.position() - this.offset;
        int ofs = 0;
        for (int i = 0; i < osds.length; ++i) {
            osdBytes[i] = osds[i].getBytes();
            assert (ofs0 + ofs <= Short.MAX_VALUE);
            tmp.putShort((short)(ofs0 + osds.length * 16 / 8 + ofs));
            ofs += osdBytes[i].length;
        }
        for (byte[] b : osdBytes) {
            tmp.put(b);
        }
    }

    @Override
    public short getOSDCount() {
        return (short)this.osdCache.length;
    }

    @Override
    public String getOSD(int osdIndex) {
        if (this.osdCache[osdIndex] == null) {
            int bufOffset = this.getOSDBufferOffset(osdIndex);
            int nextBufOffset = this.getOSDBufferOffset(osdIndex + 1);
            this.osdCache[osdIndex] = new String(this.buffer, bufOffset, nextBufOffset - bufOffset);
        }
        return this.osdCache[osdIndex];
    }

    @Override
    public StripingPolicy getStripingPolicy() {
        if (this.stripingPolicy == null) {
            ByteBuffer tmp = ByteBuffer.wrap(this.buffer, this.offset, this.len);
            short osdListStart = tmp.getShort(this.offset);
            assert (osdListStart >= 0);
            if (osdListStart == 6) {
                return null;
            }
            this.stripingPolicy = new BufferBackedStripingPolicy(this.buffer, this.offset + 6, osdListStart - 6);
        }
        return this.stripingPolicy;
    }

    @Override
    public int getReplicationFlags() {
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer, this.offset, this.len);
        return tmp.getInt(this.offset + 2);
    }

    @Override
    public void setReplicationFlags(int replFlags) {
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer, this.offset, this.len);
        tmp.putInt(this.offset + 2, replFlags);
    }

    private int getOSDBufferOffset(int osdPosition) {
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer, this.offset, this.len);
        int osdOffset = this.offset + (osdPosition >= this.osdCache.length ? this.len : (int)tmp.getShort(this.offset + tmp.getShort(this.offset) + 2 + osdPosition * 16 / 8));
        return osdOffset;
    }
}

