/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.metadata;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.xtreemfs.mrc.metadata.BufferBackedMetadata;
import org.xtreemfs.mrc.metadata.BufferBackedXLoc;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;

public class BufferBackedXLocList
extends BufferBackedMetadata
implements XLocList {
    private XLoc[] replicaCache;

    public BufferBackedXLocList(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
        ByteBuffer tmp = ByteBuffer.wrap(buffer, offset, this.len);
        int numReplicas = tmp.getInt(offset + 4);
        this.replicaCache = new XLoc[numReplicas];
    }

    public BufferBackedXLocList(BufferBackedXLoc[] replicas, String replUpdatePolicy, int version) {
        super(null, 0, 0);
        byte[] replUpdatePolicyBytes = replUpdatePolicy.getBytes();
        this.replicaCache = new XLoc[replicas.length];
        int bufSize = 12;
        for (BufferBackedXLoc repl : replicas) {
            bufSize += repl.len + 4;
        }
        this.buffer = new byte[bufSize += replUpdatePolicyBytes.length];
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer);
        tmp.putInt(version);
        tmp.putInt(replicas.length);
        tmp.position(tmp.position() + 4);
        int replOffset = tmp.position() - this.offset + replicas.length * 32 / 8;
        for (BufferBackedXLoc replica : replicas) {
            tmp.putInt(replOffset);
            replOffset += replica.getLength();
        }
        for (BufferBackedXLoc replica : replicas) {
            tmp.put(replica.getBuffer(), replica.getOffset(), replica.getLength());
        }
        int offs = tmp.position();
        tmp.position(8);
        tmp.putInt(replOffset);
        tmp.position(offs);
        tmp.put(replUpdatePolicyBytes);
        this.offset = 0;
        this.len = this.buffer.length;
    }

    @Override
    public int getReplicaCount() {
        return this.replicaCache.length;
    }

    @Override
    public XLoc getReplica(int replicaIndex) {
        if (this.replicaCache[replicaIndex] == null) {
            int index = this.getBufferOffset(replicaIndex);
            int nextIndex = replicaIndex >= this.getReplicaCount() - 1 ? this.getReplUpdatePolicyOffset() : this.getBufferOffset(replicaIndex + 1);
            int length = nextIndex - index;
            if (length == 0) {
                return null;
            }
            this.replicaCache[replicaIndex] = new BufferBackedXLoc(this.buffer, index, length);
        }
        return this.replicaCache[replicaIndex];
    }

    @Override
    public String getReplUpdatePolicy() {
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer, this.offset, this.len);
        int offs = tmp.getInt(this.offset + 8);
        return new String(this.buffer, this.offset + offs, this.len - offs);
    }

    @Override
    public int getVersion() {
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer, this.offset, this.len);
        return tmp.getInt(this.offset);
    }

    @Override
    public Iterator<XLoc> iterator() {
        return new Iterator<XLoc>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < BufferBackedXLocList.this.getReplicaCount();
            }

            @Override
            public XLoc next() {
                return BufferBackedXLocList.this.getReplica(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not implemented");
            }
        };
    }

    private int getBufferOffset(int replicaIndex) {
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer, this.offset, this.len);
        return this.offset + tmp.getInt(this.offset + 12 + replicaIndex * 32 / 8);
    }

    private int getReplUpdatePolicyOffset() {
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer, this.offset, this.len);
        return this.offset + tmp.getInt(this.offset + 8);
    }
}

