/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class AccessOperation
extends MRCOperation {
    public AccessOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.accessRequest rqArgs = (MRC.accessRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
        StorageManager sMan = vMan.getStorageManagerByName(p.getComp(0));
        PathResolver res = new PathResolver(sMan, p);
        faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        if (res.getFile() == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EACCES, "file or directory '" + rqArgs.getPath() + "' does not exist");
        }
        if ((rqArgs.getFlags() & MRC.ACCESS_FLAGS.ACCESS_FLAGS_R_OK.getNumber()) != 0) {
            faMan.checkPermission("r", sMan, res.getFile(), res.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        }
        if ((rqArgs.getFlags() & MRC.ACCESS_FLAGS.ACCESS_FLAGS_W_OK.getNumber()) != 0) {
            faMan.checkPermission("w", sMan, res.getFile(), res.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        }
        if ((rqArgs.getFlags() & MRC.ACCESS_FLAGS.ACCESS_FLAGS_X_OK.getNumber()) != 0) {
            faMan.checkPermission("x", sMan, res.getFile(), res.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        }
        rq.setResponse(Common.emptyResponse.getDefaultInstance());
        this.finishRequest(rq);
    }
}

