/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.StripingPolicy;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.stages.XLocSetCoordinator;
import org.xtreemfs.mrc.stages.XLocSetCoordinatorCallback;
import org.xtreemfs.mrc.stages.XLocSetLock;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class AddReplicaOperation
extends MRCOperation
implements XLocSetCoordinatorCallback {
    public AddReplicaOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        String fileId;
        if (this.master.getReplMasterUUID() != null && !this.master.getReplMasterUUID().equals(this.master.getConfig().getUUID().toString())) {
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT);
        }
        MRC.xtreemfs_replica_addRequest rqArgs = (MRC.xtreemfs_replica_addRequest)rq.getRequestArgs();
        FileAccessManager faMan = this.master.getFileAccessManager();
        VolumeManager vMan = this.master.getVolumeManager();
        this.validateContext(rq);
        StorageManager sMan = null;
        FileMetadata file = null;
        if (rqArgs.hasFileId()) {
            fileId = rqArgs.getFileId();
            MRCHelper.GlobalFileIdResolver idRes = new MRCHelper.GlobalFileIdResolver(fileId);
            sMan = vMan.getStorageManager(idRes.getVolumeId());
            file = sMan.getMetadata(idRes.getLocalFileId());
            if (file == null) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + rqArgs.getFileId() + "' does not exist");
            }
        } else if (rqArgs.hasVolumeName() && rqArgs.hasPath()) {
            Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
            sMan = vMan.getStorageManagerByName(p.getComp(0));
            PathResolver res = new PathResolver(sMan, p);
            res.checkIfFileDoesNotExist();
            file = res.getFile();
            fileId = MRCHelper.createGlobalFileId(sMan.getVolumeInfo(), file);
            faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        } else {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "either file ID or volume name + path required");
        }
        if (file.isDirectory()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "replicas may only be added to files");
        }
        if (sMan.getSoftlinkTarget(file.getId()) != null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "file '" + rqArgs.getFileId() + "' is a symbolic link");
        }
        XLocSetLock lock = this.master.getXLocSetCoordinator().getXLocSetLock(file, sMan);
        if (lock.isLocked()) {
            if (lock.hasCrashed()) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "Previous xLocSet change did not finish.", new Object[0]);
                }
            } else {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EAGAIN, "xLocSet change already in progress. Please retry.");
            }
        }
        faMan.checkPrivilegedPermissions(sMan, file, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        GlobalTypes.Replica newRepl = rqArgs.getNewReplica();
        GlobalTypes.StripingPolicy sp = newRepl.getStripingPolicy();
        StripingPolicy sPol = sMan.createStripingPolicy(sp.getType().toString(), sp.getStripeSize(), sp.getWidth());
        XLocList xLocList = file.getXLocList();
        assert (xLocList != null);
        if ("".equals(xLocList.getReplUpdatePolicy())) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "missing replica update policy - needs to be specified before adding replicas");
        }
        if (!MRCHelper.isResolvable(newRepl.getOsdUuidsList())) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "replica contains unresolvable OSD UUIDs in '" + newRepl.getOsdUuidsList() + "'");
        }
        if (xLocList.getReplica(0).getStripingPolicy().getStripeSize() != newRepl.getStripingPolicy().getStripeSize()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid stripe size; must be " + xLocList.getReplica(0).getStripingPolicy().getStripeSize());
        }
        if (!MRCHelper.isAddable(xLocList, newRepl.getOsdUuidsList())) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "at least one OSD already used in current X-Locations list '" + Converter.xLocListToString(xLocList) + "'");
        }
        XLoc replica = sMan.createXLoc(sPol, newRepl.getOsdUuidsList().toArray(new String[newRepl.getOsdUuidsCount()]), newRepl.getReplicationFlags());
        XLoc[] repls = new XLoc[xLocList.getReplicaCount() + 1];
        for (int i = 0; i < xLocList.getReplicaCount(); ++i) {
            XLoc repl;
            repls[i] = repl = xLocList.getReplica(i);
        }
        repls[repls.length - 1] = replica;
        XLocList extXLocList = sMan.createXLocList(repls, xLocList.getReplUpdatePolicy(), xLocList.getVersion() + 1);
        XLocSetCoordinator coordinator = this.master.getXLocSetCoordinator();
        XLocSetCoordinator.RequestMethod m = coordinator.addReplicas(fileId, file, xLocList, extXLocList, rq, this);
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(coordinator, m);
        coordinator.lockXLocSet(file, sMan, update);
        update.execute();
    }

    @Override
    public void installXLocSet(MRCRequest rq, String fileId, XLocList xLocList, XLocList oldxLocList) throws Throwable {
        MRCHelper.GlobalFileIdResolver idRes;
        VolumeManager vMan = this.master.getVolumeManager();
        StorageManager sMan = vMan.getStorageManager((idRes = new MRCHelper.GlobalFileIdResolver(fileId)).getVolumeId());
        FileMetadata file = sMan.getMetadata(idRes.getLocalFileId());
        if (file == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + fileId + "' does not exist");
        }
        file.setXLocList(xLocList);
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        sMan.setMetadata(file, (byte)1, update);
        this.master.getXLocSetCoordinator().unlockXLocSet(file, sMan, update);
        rq.setResponse(Common.emptyResponse.getDefaultInstance());
        update.execute();
    }
}

