/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.util.Iterator;
import org.xtreemfs.mrc.MRCException;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class CheckFileListOperation
extends MRCOperation {
    public CheckFileListOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.xtreemfs_check_file_existsRequest rqArgs = (MRC.xtreemfs_check_file_existsRequest)rq.getRequestArgs();
        String osd = rqArgs.getOsdUuid();
        VolumeManager vMan = this.master.getVolumeManager();
        StorageManager sMan = null;
        MRC.xtreemfs_check_file_existsResponse.Builder response = MRC.xtreemfs_check_file_existsResponse.newBuilder();
        try {
            sMan = vMan.getStorageManager(rqArgs.getVolumeId());
            response.setVolumeExists(true);
        }
        catch (UserException e) {
            response.setVolumeExists(false);
        }
        if (rqArgs.getFileIdsCount() == 0) {
            // empty if block
        }
        if (sMan != null && rqArgs.getFileIdsCount() > 0) {
            for (String fileId : rqArgs.getFileIdsList()) {
                if (fileId == null) {
                    throw new MRCException("checkFileList caused an Exception: file ID was null!");
                }
                FileMetadata mData = sMan.getMetadata(Long.parseLong(fileId));
                if (mData == null) {
                    response.addFileStates(MRC.xtreemfs_check_file_existsResponse.FILE_STATE.DELETED);
                    continue;
                }
                boolean registered = false;
                XLocList list = mData.getXLocList();
                if (list != null) {
                    Iterator<XLoc> iter = list.iterator();
                    block3: while (iter.hasNext() && !registered) {
                        XLoc loc = iter.next();
                        int count = loc.getOSDCount();
                        for (int i = 0; i < count; ++i) {
                            if (!loc.getOSD(i).equals(osd)) continue;
                            registered = true;
                            continue block3;
                        }
                    }
                }
                response.addFileStates(registered ? MRC.xtreemfs_check_file_existsResponse.FILE_STATE.REGISTERED : MRC.xtreemfs_check_file_existsResponse.FILE_STATE.ABANDONED);
            }
        }
        rq.setResponse(response.build());
        this.finishRequest(rq);
    }
}

