/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class CreateLinkOperation
extends MRCOperation {
    public CreateLinkOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        if (this.master.getReplMasterUUID() != null && !this.master.getReplMasterUUID().equals(this.master.getConfig().getUUID().toString())) {
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT);
        }
        MRC.linkRequest rqArgs = (MRC.linkRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path lp = new Path(rqArgs.getVolumeName(), rqArgs.getLinkPath());
        Path tp = new Path(rqArgs.getVolumeName(), rqArgs.getTargetPath());
        if (!lp.getComp(0).equals(tp.getComp(0))) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EXDEV, "cannot create hard links across volume boundaries");
        }
        StorageManager sMan = vMan.getStorageManagerByName(lp.getComp(0));
        PathResolver lRes = new PathResolver(sMan, lp);
        PathResolver tRes = new PathResolver(sMan, tp);
        faMan.checkSearchPermission(sMan, lRes, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        faMan.checkPermission(FileAccessManager.O_WRONLY, sMan, lRes.getParentDir(), 0L, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        lRes.checkIfFileExistsAlready();
        faMan.checkSearchPermission(sMan, tRes, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        tRes.checkIfFileDoesNotExist();
        FileMetadata target = tRes.getFile();
        if (target.isDirectory()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "no support for links to directories");
        }
        faMan.checkPermission(FileAccessManager.O_WRONLY, sMan, target, tRes.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        sMan.link(target, lRes.getParentDirId(), lRes.getFileName(), update);
        int time = (int)(TimeSync.getGlobalTime() / 1000L);
        MRCHelper.updateFileTimes(lRes.getParentsParentId(), lRes.getParentDir(), false, true, true, sMan, time, update);
        MRCHelper.updateFileTimes(tRes.getParentDirId(), target, false, true, false, sMan, time, update);
        rq.setResponse(MRC.timestampResponse.newBuilder().setTimestampS(time).build());
        update.execute();
    }
}

