/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class CreateSymLinkOperation
extends MRCOperation {
    public CreateSymLinkOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        if (this.master.getReplMasterUUID() != null && !this.master.getReplMasterUUID().equals(this.master.getConfig().getUUID().toString())) {
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT);
        }
        MRC.symlinkRequest rqArgs = (MRC.symlinkRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path p = new Path(rqArgs.getVolumeName(), rqArgs.getLinkPath());
        StorageManager sMan = vMan.getStorageManagerByName(p.getComp(0));
        PathResolver res = new PathResolver(sMan, p);
        faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        faMan.checkPermission(FileAccessManager.O_WRONLY, sMan, res.getParentDir(), 0L, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        res.checkIfFileExistsAlready();
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        int time = (int)(TimeSync.getGlobalTime() / 1000L);
        long fileId = sMan.getNextFileId();
        sMan.createSymLink(fileId, res.getParentDirId(), res.getFileName(), time, time, time, rq.getDetails().userId, rq.getDetails().groupIds.get(0), rqArgs.getTargetPath(), update);
        sMan.setLastFileId(fileId, update);
        MRCHelper.updateFileTimes(res.getParentsParentId(), res.getParentDir(), false, true, true, sMan, time, update);
        rq.setResponse(MRC.timestampResponse.newBuilder().setTimestampS(time).build());
        update.execute();
    }
}

