/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.util.HashMap;
import java.util.LinkedList;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.ErrorRecord;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class CreateVolumeOperation
extends MRCOperation {
    public CreateVolumeOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(final MRCRequest rq) throws Throwable {
        String replMasterUUID = this.master.getReplMasterUUID();
        if (replMasterUUID != null && !replMasterUUID.equals(this.master.getConfig().getUUID().toString())) {
            ServiceUUID uuid = new ServiceUUID(replMasterUUID);
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT, uuid.getAddress().getHostName() + ":" + uuid.getAddress().getPort());
        }
        final MRC.Volume volData = (MRC.Volume)rq.getRequestArgs();
        if (this.master.getConfig().getAdminPassword().length() > 0 && !this.master.getConfig().getAdminPassword().equals(rq.getDetails().password)) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "invalid password");
        }
        this.validateContext(rq);
        try {
            this.master.getFileAccessManager().getFileAccessPolicy((short)volData.getAccessControlPolicy().getNumber());
        }
        catch (Exception exc) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid file access policy ID: " + volData.getAccessControlPolicy());
        }
        final String volumeId = this.master.getVolumeManager().newVolumeId();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("name", volData.getName());
        LinkedList<String> attrs = new LinkedList<String>();
        attrs.add("version");
        Runnable rqThr = new Runnable(){

            @Override
            public void run() {
                try {
                    DIR.ServiceSet sset = CreateVolumeOperation.this.master.getDirClient().xtreemfs_service_get_by_type(null, rq.getDetails().auth, RPCAuthentication.userService, DIR.ServiceType.SERVICE_TYPE_VOLUME);
                    CreateVolumeOperation.this.processStep2(volData, volumeId, rq, sset);
                }
                catch (Exception ex) {
                    CreateVolumeOperation.this.finishRequest(rq, new ErrorRecord(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "an error has occurred", ex));
                }
            }
        };
        Thread thr = new Thread(rqThr);
        thr.start();
    }

    private void processStep2(final MRC.Volume volData, final String volumeId, final MRCRequest rq, DIR.ServiceSet response) {
        try {
            for (DIR.Service reg : response.getServicesList()) {
                if (!volData.getName().equals(reg.getName())) continue;
                String uuid = reg.getUuid();
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EEXIST, "volume '" + volData.getName() + "' already exists in Directory Service, id='" + uuid + "'");
            }
            String uid = volData.getOwnerUserId();
            String gid = volData.getOwnerGroupId();
            if ("".equals(uid)) {
                uid = rq.getDetails().userId;
            }
            if ("".equals(gid)) {
                gid = rq.getDetails().groupIds.get(0);
            }
            this.master.getVolumeManager().createVolume(this.master.getFileAccessManager(), volumeId, volData.getName(), (short)volData.getAccessControlPolicy().getNumber(), uid, gid, volData.getDefaultStripingPolicy(), volData.getMode(), volData.getQuota(), volData.getAttrsList());
            this.master.notifyVolumeCreated();
            DIR.ServiceDataMap.Builder dmap = DIR.ServiceDataMap.newBuilder();
            dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("mrc").setValue(this.master.getConfig().getUUID().toString()));
            dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("free").setValue("0"));
            for (GlobalTypes.KeyValuePair kv : volData.getAttrsList()) {
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("attr." + kv.getKey()).setValue(kv.getValue()));
            }
            final DIR.Service vol = DIR.Service.newBuilder().setType(DIR.ServiceType.SERVICE_TYPE_VOLUME).setUuid(volumeId).setVersion(0L).setName(volData.getName()).setLastUpdatedS(0L).setData(dmap).build();
            Runnable rqThr = new Runnable(){

                @Override
                public void run() {
                    try {
                        CreateVolumeOperation.this.master.getDirClient().xtreemfs_service_register(null, rq.getDetails().auth, RPCAuthentication.userService, vol);
                        CreateVolumeOperation.this.processStep3(volData, volumeId, rq);
                    }
                    catch (Exception ex) {
                        CreateVolumeOperation.this.finishRequest(rq, new ErrorRecord(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "an error has occurred", ex));
                    }
                }
            };
            Thread thr = new Thread(rqThr);
            thr.start();
        }
        catch (UserException exc) {
            if (Logging.isDebug()) {
                Logging.logUserError(7, Logging.Category.proc, this, exc);
            }
            this.finishRequest(rq, new ErrorRecord(RPC.ErrorType.ERRNO, exc.getErrno(), exc.getMessage(), exc));
        }
        catch (DatabaseException exc) {
            this.finishRequest(rq, new ErrorRecord(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "an error has occurred", exc));
        }
        catch (Throwable exc) {
            this.finishRequest(rq, new ErrorRecord(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "an error has occurred", exc));
        }
    }

    public void processStep3(MRC.Volume rqArgs, String volumeId, MRCRequest rq) {
        try {
            rq.setResponse(Common.emptyResponse.getDefaultInstance());
            this.finishRequest(rq);
        }
        catch (Throwable exc) {
            this.finishRequest(rq, new ErrorRecord(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "an error has occurred", exc));
        }
    }
}

