/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.net.InetSocketAddress;
import org.xtreemfs.common.Capability;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class DeleteOperation
extends MRCOperation {
    public DeleteOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        if (this.master.getReplMasterUUID() != null && !this.master.getReplMasterUUID().equals(this.master.getConfig().getUUID().toString())) {
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT);
        }
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path p = new Path(rq.getRequestArgs() instanceof MRC.unlinkRequest ? ((MRC.unlinkRequest)rq.getRequestArgs()).getVolumeName() : ((MRC.rmdirRequest)rq.getRequestArgs()).getVolumeName(), rq.getRequestArgs() instanceof MRC.unlinkRequest ? ((MRC.unlinkRequest)rq.getRequestArgs()).getPath() : ((MRC.rmdirRequest)rq.getRequestArgs()).getPath());
        StorageManager sMan = vMan.getStorageManagerByName(p.getComp(0));
        PathResolver res = new PathResolver(sMan, p);
        VolumeInfo volume = sMan.getVolumeInfo();
        faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        faMan.checkPermission(FileAccessManager.O_WRONLY, sMan, res.getParentDir(), 0L, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        res.checkIfFileDoesNotExist();
        FileMetadata file = res.getFile();
        faMan.checkPermission(0x400000, sMan, file, res.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        DatabaseResultSet<FileMetadata> children = sMan.getChildren(file.getId(), 0, Integer.MAX_VALUE);
        boolean hasChildren = children.hasNext();
        children.destroy();
        if (file.isDirectory() && hasChildren) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOTEMPTY, "'" + p + "' is not empty");
        }
        GlobalTypes.FileCredentials.Builder creds = null;
        if (!file.isDirectory()) {
            Capability cap = new Capability(MRCHelper.createGlobalFileId(volume, file), 0x200000, this.master.getConfig().getCapabilityTimeout(), Integer.MAX_VALUE, ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress().getHostAddress(), file.getEpoch(), false, !volume.isSnapshotsEnabled() ? GlobalTypes.SnapConfig.SNAP_CONFIG_SNAPS_DISABLED : (volume.isSnapVolume() ? GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP : GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_CURRENT), volume.getCreationTime(), this.master.getConfig().getCapabilitySecret());
            XLocList xloc = file.getXLocList();
            if (xloc != null && xloc.getReplicaCount() > 0) {
                creds = GlobalTypes.FileCredentials.newBuilder().setXcap(cap.getXCap()).setXlocs(Converter.xLocListToXLocSet(xloc));
            }
        }
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        sMan.delete(res.getParentDirId(), res.getFileName(), update);
        if (file.getLinkCount() > 1) {
            creds = null;
        }
        int time = (int)(TimeSync.getGlobalTime() / 1000L);
        MRCHelper.updateFileTimes(res.getParentsParentId(), res.getParentDir(), false, true, true, sMan, time, update);
        if (file.getLinkCount() > 1) {
            MRCHelper.updateFileTimes(res.getParentDirId(), file, false, true, false, sMan, time, update);
        }
        if (rq.getRequestArgs() instanceof MRC.unlinkRequest) {
            MRC.unlinkResponse.Builder builder = MRC.unlinkResponse.newBuilder().setTimestampS(time);
            if (creds != null) {
                builder.setCreds(creds);
            }
            rq.setResponse(builder.build());
        } else {
            rq.setResponse(MRC.timestampResponse.newBuilder().setTimestampS(time).build());
        }
        update.execute();
    }
}

