/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.ErrorRecord;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class DeleteVolumeOperation
extends MRCOperation {
    public DeleteVolumeOperation(MRCRequestDispatcher master) {
        super(master);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRequest(final MRCRequest rq) throws Throwable {
        String replMasterUUID = this.master.getReplMasterUUID();
        if (replMasterUUID != null && !replMasterUUID.equals(this.master.getConfig().getUUID().toString())) {
            ServiceUUID uuid = new ServiceUUID(replMasterUUID);
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT, uuid.getAddress().getHostName() + ":" + uuid.getAddress().getPort());
        }
        MRC.xtreemfs_rmvolRequest rqArgs = (MRC.xtreemfs_rmvolRequest)rq.getRequestArgs();
        if (this.master.getConfig().getAdminPassword().length() > 0 && !this.master.getConfig().getAdminPassword().equals(rq.getDetails().password)) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "invalid password");
        }
        StorageManager sMan = this.master.getVolumeManager().getStorageManagerByName(rqArgs.getVolumeName());
        final VolumeInfo volume = sMan.getVolumeInfo();
        FileMetadata file = sMan.getMetadata(0L, volume.getName());
        if (this.master.getConfig().getAdminPassword().length() == 0) {
            this.master.getFileAccessManager().checkPrivilegedPermissions(sMan, file, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        }
        this.master.pauseHeartbeatThread();
        try {
            this.master.getVolumeManager().deleteVolume(volume.getId(), this.master, rq);
            this.master.notifyVolumeDeleted();
        }
        finally {
            this.master.resumeHeartbeatThread();
        }
        Runnable asyncDeregisterRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    DeleteVolumeOperation.this.master.getDirClient().xtreemfs_service_deregister(null, rq.getDetails().auth, RPCAuthentication.userService, volume.getId());
                    rq.setResponse(Common.emptyResponse.getDefaultInstance());
                    DeleteVolumeOperation.this.finishRequest(rq);
                }
                catch (Exception exc) {
                    DeleteVolumeOperation.this.finishRequest(rq, new ErrorRecord(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "An error has occurred at the MRC. Details: " + exc.getMessage(), exc));
                }
            }
        };
        new Thread(asyncDeregisterRunner).start();
    }
}

