/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.xtreemfs.foundation.VersionManagement;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class DumpDBOperation
extends MRCOperation {
    public DumpDBOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.xtreemfs_dump_restore_databaseRequest rqArgs = (MRC.xtreemfs_dump_restore_databaseRequest)rq.getRequestArgs();
        if (this.master.getConfig().getAdminPassword().length() > 0 && !this.master.getConfig().getAdminPassword().equals(rq.getDetails().password)) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "invalid password");
        }
        if (!new File(rqArgs.getDumpFile() + ".inprogress").exists()) {
            LinkedList<StorageManager> storageManagers = new LinkedList<StorageManager>();
            VolumeManager vMan = this.master.getVolumeManager();
            Collection<StorageManager> sManColl = vMan.getStorageManagers();
            if (sManColl == null) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "cannot dump volumes because volume manager has not yet been initialized");
            }
            for (StorageManager sMan : sManColl) {
                FileMetadata rootDir = sMan.getMetadata(1L);
                try {
                    vMan.createSnapshot(sMan.getVolumeInfo().getId(), ".dump", 0L, rootDir, true);
                }
                catch (UserException exc) {
                    vMan.deleteSnapshot(sMan.getVolumeInfo().getId(), rootDir, ".dump");
                    vMan.createSnapshot(sMan.getVolumeInfo().getId(), ".dump", 0L, rootDir, true);
                }
                storageManagers.add(vMan.getStorageManagerByName(sMan.getVolumeInfo().getName() + '@' + ".dump"));
            }
            DumpWriter dw = new DumpWriter(storageManagers, new File(rqArgs.getDumpFile()));
            dw.start();
        }
        rq.setResponse(Common.emptyResponse.getDefaultInstance());
        this.finishRequest(rq);
    }

    class DumpWriter
    extends Thread {
        private File dumpFile;
        private List<StorageManager> sManList;

        public DumpWriter(List<StorageManager> sManList, File dumpFile) {
            this.dumpFile = dumpFile;
            this.sManList = sManList;
        }

        @Override
        public void run() {
            File df = new File(this.dumpFile + ".inprogress");
            try {
                BufferedWriter xmlWriter = new BufferedWriter(new FileWriter(df));
                xmlWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                xmlWriter.write("<filesystem dbversion=\"" + VersionManagement.getMrcDataVersion() + "\">\n");
                for (StorageManager sMan : this.sManList) {
                    VolumeInfo vol = sMan.getVolumeInfo();
                    xmlWriter.write("<volume id=\"" + vol.getId() + "\" name=\"" + vol.getName() + "\" acPolicy=\"" + vol.getAcPolicyId() + "\">\n");
                    sMan.dumpDB(xmlWriter);
                    xmlWriter.write("</volume>\n");
                }
                xmlWriter.write("</filesystem>\n");
                xmlWriter.close();
                df.renameTo(this.dumpFile);
            }
            catch (Exception exc) {
                Logging.logMessage(3, Logging.Category.storage, this, "an error has occurred while dumping the database: %s", OutputUtils.stackTraceToString(exc));
            }
        }
    }
}

