/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class FSetAttrOperation
extends MRCOperation {
    public FSetAttrOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        boolean setAttributes;
        MRC.fsetattrRequest rqArgs = (MRC.fsetattrRequest)rq.getRequestArgs();
        Capability cap = new Capability(rqArgs.getCap(), this.master.getConfig().getCapabilitySecret());
        if (!cap.hasValidSignature()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, cap + " does not have a valid signature");
        }
        if (cap.hasExpired()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, cap + " has expired");
        }
        MRCHelper.GlobalFileIdResolver idRes = new MRCHelper.GlobalFileIdResolver(cap.getFileId());
        StorageManager sMan = this.master.getVolumeManager().getStorageManager(idRes.getVolumeId());
        FileMetadata file = sMan.getMetadata(idRes.getLocalFileId());
        if (file == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + cap.getFileId() + "' does not exist");
        }
        boolean setMode = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_MODE.getNumber()) == MRC.Setattrs.SETATTR_MODE.getNumber();
        boolean setUID = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_UID.getNumber()) == MRC.Setattrs.SETATTR_UID.getNumber();
        boolean setGID = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_GID.getNumber()) == MRC.Setattrs.SETATTR_GID.getNumber();
        boolean setSize = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_SIZE.getNumber()) == MRC.Setattrs.SETATTR_SIZE.getNumber();
        boolean setAtime = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_ATIME.getNumber()) == MRC.Setattrs.SETATTR_ATIME.getNumber();
        boolean setCtime = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_CTIME.getNumber()) == MRC.Setattrs.SETATTR_CTIME.getNumber();
        boolean setMtime = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_MTIME.getNumber()) == MRC.Setattrs.SETATTR_MTIME.getNumber();
        boolean bl = setAttributes = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_ATTRIBUTES.getNumber()) == MRC.Setattrs.SETATTR_ATTRIBUTES.getNumber();
        if (setSize) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "setting file sizes not allowed on open files; use 'xtreemfs_update_file_size' instead");
        }
        if (setMode || setUID || setGID || setAttributes) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "setting modes, UIDs, GIDs and Win32 attributes not allowed on open files");
        }
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        if (setAtime || setCtime || setMtime) {
            if (setAtime) {
                file.setAtime((int)(rqArgs.getStbuf().getAtimeNs() / 1000000000L));
            }
            if (setCtime) {
                file.setCtime((int)(rqArgs.getStbuf().getCtimeNs() / 1000000000L));
            }
            if (setMtime) {
                file.setMtime((int)(rqArgs.getStbuf().getMtimeNs() / 1000000000L));
            }
        }
        if (setUID || setGID || setAttributes) {
            sMan.setMetadata(file, (byte)1, update);
        }
        if (setAtime || setCtime || setMtime || setSize) {
            sMan.setMetadata(file, (byte)0, update);
        }
        rq.setResponse(Common.emptyResponse.getDefaultInstance());
        update.execute();
    }
}

