/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.net.InetSocketAddress;
import org.xtreemfs.common.Capability;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class GetFileCredentialsOperation
extends MRCOperation {
    public GetFileCredentialsOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.xtreemfs_get_file_credentialsRequest rqArgs = (MRC.xtreemfs_get_file_credentialsRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        MRCHelper.GlobalFileIdResolver gfr = new MRCHelper.GlobalFileIdResolver(rqArgs.getFileId());
        String volId = gfr.getVolumeId();
        Long localFileID = gfr.getLocalFileId();
        StorageManager sMan = vMan.getStorageManager(volId);
        VolumeInfo volume = sMan.getVolumeInfo();
        FileMetadata file = sMan.getMetadata(localFileID);
        if (file == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + rqArgs.getFileId() + "' does not exist");
        }
        faMan.checkPrivilegedPermissions(sMan, file, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        Capability cap = new Capability(MRCHelper.createGlobalFileId(volume, file), FileAccessManager.O_RDONLY, this.master.getConfig().getCapabilityTimeout(), TimeSync.getGlobalTime() / 1000L + (long)this.master.getConfig().getCapabilityTimeout(), ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress().getHostAddress(), file.getEpoch(), false, !volume.isSnapshotsEnabled() ? GlobalTypes.SnapConfig.SNAP_CONFIG_SNAPS_DISABLED : (volume.isSnapVolume() ? GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP : GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_CURRENT), volume.getCreationTime(), this.master.getConfig().getCapabilitySecret());
        GlobalTypes.XLocSet newXlocSet = null;
        newXlocSet = file.isReadOnly() ? Converter.xLocListToXLocSet(file.getXLocList()).setReadOnlyFileSize(file.getSize()).build() : Converter.xLocListToXLocSet(file.getXLocList()).build();
        GlobalTypes.FileCredentials fc = GlobalTypes.FileCredentials.newBuilder().setXcap(cap.getXCap()).setXlocs(newXlocSet).build();
        rq.setResponse(fc);
        this.finishRequest(rq);
    }
}

