/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.util.Collection;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.metadata.XAttr;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.operations.StatFSOperation;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class GetLocalVolumesOperation
extends MRCOperation {
    public GetLocalVolumesOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        Collection<StorageManager> sMans = this.master.getVolumeManager().getStorageManagers();
        if (sMans == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "cannot retrieve volume list because volume manager has not yet been initialized");
        }
        if (this.master.getConfig().getAdminPassword().length() > 0 && !this.master.getConfig().getAdminPassword().equals(rq.getDetails().password)) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "Invalid password. If you see this error at mount.xtreemfs when mounting a volume, please update your client to version 1.3.1 or newer.");
        }
        MRC.Volumes.Builder vSet = MRC.Volumes.newBuilder();
        for (StorageManager sMan : sMans) {
            MRC.Volume.Builder vol = MRC.Volume.newBuilder();
            MRC.StatVFS vInfo = StatFSOperation.getVolumeInfo(this.master, sMan);
            vol.setAccessControlPolicy(vInfo.getAccessControlPolicy()).setDefaultStripingPolicy(vInfo.getDefaultStripingPolicy()).setId(vInfo.getFsid()).setMode(vInfo.getMode()).setName(vInfo.getName()).setOwnerGroupId(vInfo.getOwnerGroupId()).setOwnerUserId(vInfo.getOwnerUserId());
            String prefix = "xtreemfs.volattr.";
            DatabaseResultSet<XAttr> attrs = sMan.getXAttrs(1L, "");
            while (attrs.hasNext()) {
                XAttr attr = (XAttr)attrs.next();
                if (!attr.getKey().startsWith("xtreemfs.volattr.")) continue;
                byte[] valBytes = attr.getValue();
                vol.addAttrs(GlobalTypes.KeyValuePair.newBuilder().setKey(attr.getKey().substring("xtreemfs.volattr.".length())).setValue(valBytes == null ? null : new String(valBytes)));
            }
            attrs.destroy();
            vSet.addVolumes(vol);
        }
        rq.setResponse(vSet.build());
        this.finishRequest(rq);
    }
}

