/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.net.InetSocketAddress;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class GetSuitableOSDsOperation
extends MRCOperation {
    public GetSuitableOSDsOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        FileMetadata file;
        StorageManager sMan;
        String volumeId;
        MRC.xtreemfs_get_suitable_osdsRequest rqArgs = (MRC.xtreemfs_get_suitable_osdsRequest)rq.getRequestArgs();
        FileAccessManager faMan = this.master.getFileAccessManager();
        VolumeManager vMan = this.master.getVolumeManager();
        if (rqArgs.hasFileId()) {
            MRCHelper.GlobalFileIdResolver idRes = new MRCHelper.GlobalFileIdResolver(rqArgs.getFileId());
            volumeId = idRes.getVolumeId();
            sMan = vMan.getStorageManager(idRes.getVolumeId());
            file = sMan.getMetadata(idRes.getLocalFileId());
            if (file == null) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + rqArgs.getFileId() + "' does not exist");
            }
        } else if (rqArgs.hasVolumeName() && rqArgs.hasPath()) {
            Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
            sMan = vMan.getStorageManagerByName(p.getComp(0));
            PathResolver res = new PathResolver(sMan, p);
            res.checkIfFileDoesNotExist();
            file = res.getFile();
            faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
            volumeId = sMan.getVolumeInfo().getId();
        } else {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "either file ID or volume name + path required");
        }
        if (file.isDirectory()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EISDIR, "xtreemfs_get_suitable_osds must be invoked on a file");
        }
        DIR.ServiceSet.Builder usableOSDs = this.master.getOSDStatusManager().getUsableOSDs(volumeId, ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress(), null, file.getXLocList(), rqArgs.getNumOsds());
        MRC.xtreemfs_get_suitable_osdsResponse.Builder resp = MRC.xtreemfs_get_suitable_osdsResponse.newBuilder();
        for (int i = 0; i < usableOSDs.getServicesCount(); ++i) {
            resp.addOsdUuids(usableOSDs.getServices(i).getUuid());
        }
        rq.setResponse(resp.build());
        this.finishRequest(rq);
    }
}

