/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import com.google.protobuf.ByteString;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class GetXAttrOperation
extends MRCOperation {
    public GetXAttrOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.getxattrRequest rqArgs = (MRC.getxattrRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
        StorageManager sMan = vMan.getStorageManagerByName(p.getComp(0));
        PathResolver res = new PathResolver(sMan, p);
        faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        res.checkIfFileDoesNotExist();
        FileMetadata file = res.getFile();
        byte[] value = null;
        if (rqArgs.getName().startsWith("xtreemfs.")) {
            value = MRCHelper.getSysAttrValue(this.master.getConfig(), sMan, this.master.getOSDStatusManager(), faMan, res.toString(), file, rqArgs.getName().substring(9)).getBytes();
        } else {
            value = sMan.getXAttr(file.getId(), rq.getDetails().userId, rqArgs.getName());
            if (value == null) {
                value = sMan.getXAttr(file.getId(), "*", rqArgs.getName());
            }
        }
        if (value == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENODATA);
        }
        rq.setResponse(MRC.getxattrResponse.newBuilder().setValue(new String(value)).setValueBytes(ByteString.copyFrom(value)).build());
        this.finishRequest(rq);
    }
}

