/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.XAttr;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class GetXAttrsOperation
extends MRCOperation {
    public GetXAttrsOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        XAttr attr;
        MRC.listxattrRequest rqArgs = (MRC.listxattrRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
        StorageManager sMan = vMan.getStorageManagerByName(p.getComp(0));
        PathResolver res = new PathResolver(sMan, p);
        faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        res.checkIfFileDoesNotExist();
        FileMetadata file = res.getFile();
        HashMap<String, byte[]> attrs = new HashMap<String, byte[]>();
        DatabaseResultSet<XAttr> myAttrs = sMan.getXAttrs(file.getId(), rq.getDetails().userId);
        DatabaseResultSet<XAttr> globalAttrs = sMan.getXAttrs(file.getId(), "*");
        while (globalAttrs.hasNext()) {
            attr = (XAttr)globalAttrs.next();
            attrs.put(attr.getKey(), attr.getValue());
        }
        globalAttrs.destroy();
        while (myAttrs.hasNext()) {
            attr = (XAttr)myAttrs.next();
            attrs.put(attr.getKey(), attr.getValue());
        }
        myAttrs.destroy();
        for (MRCHelper.SysAttrs sysAttrs : MRCHelper.SysAttrs.values()) {
            String key = "xtreemfs." + sysAttrs.toString();
            String value = MRCHelper.getSysAttrValue(this.master.getConfig(), sMan, this.master.getOSDStatusManager(), faMan, res.toString(), file, sysAttrs.toString());
            if (value.equals("")) continue;
            attrs.put(key, value.getBytes());
        }
        if (file.getId() == 1L) {
            List<String> policyAttrNames = MRCHelper.getSpecialAttrNames(sMan, "policies");
            for (String attr3 : policyAttrNames) {
                attrs.put(attr3, sMan.getXAttr(1L, "", attr3));
            }
            List<String> volAttrAttrNames = MRCHelper.getSpecialAttrNames(sMan, "volattr");
            for (String string : volAttrAttrNames) {
                attrs.put(string, sMan.getXAttr(1L, "", string));
            }
        }
        MRC.listxattrResponse.Builder result = MRC.listxattrResponse.newBuilder();
        for (Map.Entry attr4 : attrs.entrySet()) {
            MRC.XAttr.Builder builder = MRC.XAttr.newBuilder().setName((String)attr4.getKey());
            if (!rqArgs.getNamesOnly()) {
                builder.setValue(new String((byte[])attr4.getValue())).setValueBytes(ByteString.copyFrom((byte[])attr4.getValue()));
            }
            result.addXattrs(builder.build());
        }
        rq.setResponse(result.build());
        this.finishRequest(rq);
    }
}

