/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class GetXLocSetOperation
extends MRCOperation {
    public GetXLocSetOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.xtreemfs_get_xlocsetRequest rqArgs = (MRC.xtreemfs_get_xlocsetRequest)rq.getRequestArgs();
        FileAccessManager faMan = this.master.getFileAccessManager();
        VolumeManager vMan = this.master.getVolumeManager();
        StorageManager sMan = null;
        FileMetadata file = null;
        if (rqArgs.hasXcap()) {
            Capability cap = new Capability(rqArgs.getXcap(), this.master.getConfig().getCapabilitySecret());
            if (!cap.hasValidSignature()) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, cap + " does not have a valid signature");
            }
            if (cap.hasExpired()) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, cap + " has expired");
            }
        } else {
            this.validateContext(rq);
        }
        if (rqArgs.hasXcap() || rqArgs.hasFileId()) {
            String fileId = rqArgs.hasFileId() ? rqArgs.getFileId() : rqArgs.getXcap().getFileId();
            MRCHelper.GlobalFileIdResolver idRes = new MRCHelper.GlobalFileIdResolver(fileId);
            sMan = vMan.getStorageManager(idRes.getVolumeId());
            file = sMan.getMetadata(idRes.getLocalFileId());
            if (file == null) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + idRes.getLocalFileId() + "' does not exist");
            }
        } else if (rqArgs.hasVolumeName() && rqArgs.hasPath()) {
            Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
            sMan = vMan.getStorageManagerByName(p.getComp(0));
            PathResolver res = new PathResolver(sMan, p);
            res.checkIfFileDoesNotExist();
            file = res.getFile();
            faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        } else {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "Either file ID, volume name + path or a valid XCap is required");
        }
        if (file.isDirectory()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EISDIR, file.getId() + " is a directory");
        }
        if (sMan.getSoftlinkTarget(file.getId()) != null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "file '" + rqArgs.getFileId() + "' is a symbolic link");
        }
        XLocList xLocList = file.getXLocList();
        assert (xLocList != null);
        GlobalTypes.XLocSet xLocSet = Converter.xLocListToXLocSet(xLocList).build();
        rq.setResponse(xLocSet);
        this.finishRequest(rq);
    }
}

